/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class SplashManager extends Internal.SimplePreparableReloadListener<Internal.List<string>> {
        constructor($$0: Internal.User_)
        getName(): string;
        getSplash(): Internal.SplashRenderer;
        get name(): string
        get splash(): Internal.SplashRenderer
    }
    type SplashManager_ = SplashManager;
    class DirectedDirectionalBlock extends Internal.HorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.TransformableBlock {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getTargetDirection(pState: Internal.BlockState_): Internal.Direction;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly TARGET: Internal.EnumProperty<Internal.AttachFace>;
    }
    type DirectedDirectionalBlock_ = DirectedDirectionalBlock;
    class PressurePlateBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        behaviour(wt: string): this;
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
        behaviour(wt: Internal.BlockSetType_): this;
    }
    type PressurePlateBlockBuilder_ = PressurePlateBlockBuilder;
    class TimeComponent extends Internal.Record implements Internal.RecipeComponent<number> {
        constructor(name: string, scale: number)
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<number>;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<number>;
        isOutput(recipe: Internal.RecipeJS_, value: number, match: Internal.ReplacementMatch_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<number>;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<number>, json: Internal.JsonObject_): void;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<number>, map: Internal.Map_<any, any>): void;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<number>;
        checkEmpty(key: Internal.RecipeKey_<number>, value: number): string;
        replaceInput(recipe: Internal.RecipeJS_, original: number, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): number;
        write(recipe: Internal.RecipeJS_, value: number): Internal.JsonElement;
        orSelf(): Internal.RecipeComponent<number>;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        key(name: string): Internal.RecipeKey<number>;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<number, O>;
        componentType(): string;
        asArray(): Internal.ArrayRecipeComponent<number>;
        isInput(recipe: Internal.RecipeJS_, value: number, match: Internal.ReplacementMatch_): boolean;
        static builder(): Internal.RecipeComponentBuilder;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<number>;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        read(arg0: Internal.RecipeJS_, arg1: any): any;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, number>>;
        name(): string;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, number>>;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<number>, json: Internal.JsonObject_): void;
        scale(): number;
        checkValueHasChanged(oldValue: number, newValue: number): boolean;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<number, O>;
        replaceOutput(recipe: Internal.RecipeJS_, original: number, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): number;
        static readonly SECONDS: Internal.TimeComponent;
        static readonly TICKS: Internal.TimeComponent;
        static readonly DYNAMIC: Internal.DynamicRecipeComponent;
        static readonly MINUTES: Internal.TimeComponent;
    }
    type TimeComponent_ = TimeComponent;
    class FishingSpeedEnchantment extends Internal.Enchantment {
    }
    type FishingSpeedEnchantment_ = FishingSpeedEnchantment;
    class SculkSensorBlockEntity extends Internal.BlockEntity implements Internal.GameEventListener$Holder<Internal.VibrationSystem$Listener>, Internal.VibrationSystem {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getLastVibrationFrequency(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        static getGameEventFrequency($$0: Internal.GameEvent_): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getVibrationUser(): Internal.VibrationSystem$User;
        onLoad(): void;
        createVibrationUser(): Internal.VibrationSystem$User;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static getResonanceEventByFrequency($$0: number): Internal.GameEvent;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getListener(): Internal.GameEventListener;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getListener(): Internal.VibrationSystem$Listener;
        getVibrationData(): Internal.VibrationSystem$Data;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setLastVibrationFrequency($$0: number): void;
        static getRedstoneStrengthForDistance($$0: number, $$1: number): number;
        get lastVibrationFrequency(): number
        get vibrationUser(): Internal.VibrationSystem$User
        get listener(): Internal.GameEventListener
        get listener(): Internal.VibrationSystem$Listener
        get vibrationData(): Internal.VibrationSystem$Data
        set lastVibrationFrequency($$0: number)
    }
    type SculkSensorBlockEntity_ = SculkSensorBlockEntity;
    class RenderBuffers implements Internal.MemoryTrackingRenderBuffers, Internal.RenderBuffersExt, Internal.DrawCallTrackingRenderBuffers {
        constructor()
        freeAndDeleteBuffers(): void;
        bufferSource(): Internal.MultiBufferSource$BufferSource;
        getMaxBegins(): number;
        beginLevelRendering(): void;
        getDrawCalls(): number;
        getMiscBufferAllocatedSize(): number;
        getRenderTypes(): number;
        getEntityBufferAllocatedSize(): number;
        resetDrawCounts(): void;
        crumblingBufferSource(): Internal.MultiBufferSource$BufferSource;
        endLevelRendering(): void;
        fixedBufferPack(): Internal.ChunkBufferBuilderPack;
        outlineBufferSource(): Internal.OutlineBufferSource;
        get maxBegins(): number
        get drawCalls(): number
        get miscBufferAllocatedSize(): number
        get renderTypes(): number
        get entityBufferAllocatedSize(): number
    }
    type RenderBuffers_ = RenderBuffers;
    interface Comparison$Predicate {
        abstract test(arg0: Internal.EmiStack_, arg1: Internal.EmiStack_): boolean;
        (arg0: Internal.EmiStack, arg1: Internal.EmiStack): boolean;
    }
    type Comparison$Predicate_ = Comparison$Predicate;
    class PistonType extends Internal.Enum<Internal.PistonType> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.PistonType;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.PistonType[];
        get serializedName(): string
        static readonly STICKY: Internal.PistonType;
        static readonly DEFAULT: Internal.PistonType;
    }
    type PistonType_ = "sticky" | PistonType | "default";
    class BrambleFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BrambleFeature_ = BrambleFeature;
    class ModuleLayer {
        defineModulesWithManyLoaders(arg0: Internal.Configuration_, arg1: Internal.ClassLoader_): this;
        static boot(): Internal.ModuleLayer;
        findLoader(arg0: string): Internal.ClassLoader;
        static defineModulesWithManyLoaders(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer>, arg2: Internal.ClassLoader_): Internal.ModuleLayer$Controller;
        static defineModules(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer>, arg2: Internal.Function_<string, Internal.ClassLoader>): Internal.ModuleLayer$Controller;
        defineModulesWithOneLoader(arg0: Internal.Configuration_, arg1: Internal.ClassLoader_): this;
        modules(): Internal.Set<Internal.Module>;
        static defineModulesWithOneLoader(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer>, arg2: Internal.ClassLoader_): Internal.ModuleLayer$Controller;
        parents(): Internal.List<Internal.ModuleLayer>;
        defineModules(arg0: Internal.Configuration_, arg1: Internal.Function_<string, Internal.ClassLoader>): this;
        static empty(): Internal.ModuleLayer;
        configuration(): Internal.Configuration;
        findModule(arg0: string): Internal.Optional<Internal.Module>;
    }
    type ModuleLayer_ = ModuleLayer;
    class CalculationStrategy extends Internal.Enum<Internal.CalculationStrategy> {
        static values(): Internal.CalculationStrategy[];
        static valueOf(name: string): Internal.CalculationStrategy;
        static readonly CRAFT_LESS: Internal.CalculationStrategy;
        static readonly REPORT_MISSING_ITEMS: Internal.CalculationStrategy;
    }
    type CalculationStrategy_ = "report_missing_items" | CalculationStrategy | "craft_less";
    interface ValueLayout$OfInt extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type ValueLayout$OfInt_ = ValueLayout$OfInt;
    class AllIcons implements Internal.ScreenElement {
        constructor(x: number, y: number)
        asStencil(): Internal.DelegatedStencilElement;
        bind(): void;
        render(ms: Internal.PoseStack_, buffer: Internal.MultiBufferSource_, color: number): void;
        render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
        static readonly I_WHITELIST_AND: Internal.AllIcons;
        static readonly I_ARM_ROUND_ROBIN: Internal.AllIcons;
        static readonly I_SEQ_REPEAT: Internal.AllIcons;
        static readonly I_PATTERN_CHECKERED: Internal.AllIcons;
        static readonly VALUE_BOX_HOVER_8PX: Internal.AllIcons;
        static readonly I_MTD_REPLAY: Internal.AllIcons;
        static readonly I_TOOL_MOVE_Y: Internal.AllIcons;
        static readonly I_PRIORITY_HIGH: Internal.AllIcons;
        static readonly I_PATTERN_CHANCE_50: Internal.AllIcons;
        static readonly I_CONFIG_PREV: Internal.AllIcons;
        static readonly I_ATTACHED: Internal.AllIcons;
        static readonly I_SCHEMATIC: Internal.AllIcons;
        static readonly I_SEND_AND_RECEIVE: Internal.AllIcons;
        static readonly I_CONFIG_OPEN: Internal.AllIcons;
        static readonly I_FX_FIELD_OFF: Internal.AllIcons;
        static readonly I_FX_FIELD_ON: Internal.AllIcons;
        static readonly I_REFRESH: Internal.AllIcons;
        static readonly I_PLACE: Internal.AllIcons;
        static readonly I_OVERLAY: Internal.AllIcons;
        static readonly I_MOVE_PLACE_RETURNED: Internal.AllIcons;
        static readonly I_CONFIG_SAVE: Internal.AllIcons;
        static readonly I_CONFIRM: Internal.AllIcons;
        static readonly I_ROLLER_FILL: Internal.AllIcons;
        static readonly I_MOVE_NEVER_PLACE: Internal.AllIcons;
        static readonly I_TUNNEL_FORCED_ROUND_ROBIN: Internal.AllIcons;
        static readonly I_PATTERN_SOLID: Internal.AllIcons;
        static readonly I_DISABLE: Internal.AllIcons;
        static readonly I_TOOL_MOVE_XZ: Internal.AllIcons;
        static readonly I_PATTERN_CHANCE_75: Internal.AllIcons;
        static readonly ICON_ATLAS_SIZE: 256;
        static readonly I_SCROLL: Internal.AllIcons;
        static readonly I_TUNNEL_FORCED_SPLIT: Internal.AllIcons;
        static readonly I_CONFIG_UNLOCKED: Internal.AllIcons;
        static readonly I_PASSIVE: Internal.AllIcons;
        static readonly I_CONFIG_LOCKED: Internal.AllIcons;
        static readonly I_PRIORITY_VERY_HIGH: Internal.AllIcons;
        static readonly I_MTD_LEFT: Internal.AllIcons;
        static readonly I_TOOLBOX: Internal.AllIcons;
        static readonly I_MTD_SLOW_MODE: Internal.AllIcons;
        static readonly I_OPEN_FOLDER: Internal.AllIcons;
        static readonly I_MINUTE_HAND_FIRST: Internal.AllIcons;
        static readonly I_ROTATE_PLACE: Internal.AllIcons;
        static readonly I_PATTERN_CHECKERED_INVERSED: Internal.AllIcons;
        static readonly I_HOUR_HAND_FIRST_24: Internal.AllIcons;
        static readonly I_ARM_FORCED_ROUND_ROBIN: Internal.AllIcons;
        static readonly I_REPLACE_ANY: Internal.AllIcons;
        static readonly I_CONFIG_BACK: Internal.AllIcons;
        static readonly I_PARTIAL_REQUESTS: Internal.AllIcons;
        static readonly I_MOVE_PLACE: Internal.AllIcons;
        static readonly I_TARGET: Internal.AllIcons;
        static readonly I_TUNNEL_SYNCHRONIZE: Internal.AllIcons;
        static readonly I_FOLLOW_DIAGONAL: Internal.AllIcons;
        static readonly I_ROLLER_PAVE: Internal.AllIcons;
        static readonly I_REPLACE_EMPTY: Internal.AllIcons;
        static readonly I_ROTATE_CCW: Internal.AllIcons;
        static readonly I_CLEAR: Internal.AllIcons;
        static readonly I_WHITELIST_NOT: Internal.AllIcons;
        static readonly I_FLATTEN: Internal.AllIcons;
        static readonly I_MTD_CLOSE: Internal.AllIcons;
        static readonly I_CENTERED: Internal.AllIcons;
        static readonly I_SKIP_BLOCK_ENTITIES: Internal.AllIcons;
        static readonly I_BLACKLIST: Internal.AllIcons;
        static readonly I_WHITELIST: Internal.AllIcons;
        static readonly I_MTD_RIGHT: Internal.AllIcons;
        static readonly I_CONFIG_DISCARD: Internal.AllIcons;
        static readonly I_FX_BLEND_OFF: Internal.AllIcons;
        static readonly I_WHITELIST_OR: Internal.AllIcons;
        static readonly I_TOOL_DEPLOY: Internal.AllIcons;
        static readonly I_CONFIG_RESET: Internal.AllIcons;
        static readonly I_ADD: Internal.AllIcons;
        static readonly I_CART_ROTATE: Internal.AllIcons;
        static readonly I_SEND_ONLY: Internal.AllIcons;
        static readonly I_REPLACE: Internal.AllIcons;
        static readonly VALUE_BOX_HOVER_4PX: Internal.AllIcons;
        static readonly I_TOOL_MIRROR: Internal.AllIcons;
        static readonly I_CLEAR_CHECKED: Internal.AllIcons;
        static readonly I_ADD_INVERTED_ATTRIBUTE: Internal.AllIcons;
        static readonly ICON_ATLAS: ResourceLocation;
        static readonly I_3x3: Internal.AllIcons;
        static readonly I_RMB: Internal.AllIcons;
        static readonly I_PAUSE: Internal.AllIcons;
        static readonly I_TOOL_ROTATE: Internal.AllIcons;
        static readonly I_FLIP: Internal.AllIcons;
        static readonly I_PRIORITY_LOW: Internal.AllIcons;
        static readonly I_INSERTED: Internal.AllIcons;
        static readonly I_FX_SURFACE_ON: Internal.AllIcons;
        static readonly I_TUNNEL_PREFER_NEAREST: Internal.AllIcons;
        static readonly I_ROLLER_WIDE_FILL: Internal.AllIcons;
        static readonly I_CONFIG_NEXT: Internal.AllIcons;
        static readonly I_DONT_REPLACE: Internal.AllIcons;
        static readonly I_FX_SURFACE_OFF: Internal.AllIcons;
        static readonly I_VIEW_SCHEDULE: Internal.AllIcons;
        static readonly I_DICE: Internal.AllIcons;
        static readonly I_NONE: Internal.AllIcons;
        static readonly I_ACTIVE: Internal.AllIcons;
        static readonly I_ROTATE_PLACE_RETURNED: Internal.AllIcons;
        static readonly I_CART_ROTATE_PAUSED: Internal.AllIcons;
        static readonly I_FX_BLEND: Internal.AllIcons;
        static readonly VALUE_BOX_HOVER_6PX: Internal.AllIcons;
        static readonly I_PLAY: Internal.AllIcons;
        static readonly I_FILL: Internal.AllIcons;
        static readonly I_SKIP_MISSING: Internal.AllIcons;
        static readonly I_HOUR_HAND_FIRST: Internal.AllIcons;
        static readonly I_REPLACE_SOLID: Internal.AllIcons;
        static readonly I_TUNNEL_ROUND_ROBIN: Internal.AllIcons;
        static readonly I_TUNNEL_RANDOMIZE: Internal.AllIcons;
        static readonly I_PLACEMENT_SETTINGS: Internal.AllIcons;
        static readonly I_MTD_USER_MODE: Internal.AllIcons;
        static readonly I_FULL_REQUESTS: Internal.AllIcons;
        static readonly I_LMB: Internal.AllIcons;
        static readonly I_TUNNEL_SPLIT: Internal.AllIcons;
        static readonly I_ARM_PREFER_FIRST: Internal.AllIcons;
        static readonly I_TRASH: Internal.AllIcons;
        static readonly I_PRIORITY_VERY_LOW: Internal.AllIcons;
        static readonly I_MOVE_GAUGE: Internal.AllIcons;
        static readonly I_PATTERN_CHANCE_25: Internal.AllIcons;
        static readonly I_CART_ROTATE_LOCKED: Internal.AllIcons;
        static readonly I_STOP: Internal.AllIcons;
        static readonly I_RESPECT_NBT: Internal.AllIcons;
        static readonly I_FOLLOW_MATERIAL: Internal.AllIcons;
        static readonly I_IGNORE_NBT: Internal.AllIcons;
        static readonly I_ROTATE_NEVER_PLACE: Internal.AllIcons;
        static readonly I_MTD_SCAN: Internal.AllIcons;
    }
    type AllIcons_ = AllIcons;
    class ServerLevel extends Internal.Level implements Internal.IServerLevel, Internal.ISafeBlockGetter, me.jellysquid.mods.lithium.mixin.util.entity_movement_tracking.ServerWorldAccessor, com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor, Internal.ServerWorldExtended, me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerWorldAccessor, Internal.MultipartPartsHolder, io.github.fabricators_of_create.porting_lib.entity.extensions.LevelExtensions, Internal.ServerLevelKJS, Internal.ServerWorldCache, io.github.fabricators_of_create.porting_lib.transfer.internal.extensions.LevelExtensions, Internal.ServerWorldAccessor, Internal.WorldGenLevel, Internal.ExtendedWorld {
        constructor($$0: Internal.MinecraftServer_, $$1: Internal.Executor_, $$2: Internal.LevelStorageSource$LevelStorageAccess_, $$3: Internal.ServerLevelData_, $$4: Internal.ResourceKey_<Internal.Level>, $$5: Internal.LevelStem_, $$6: Internal.ChunkProgressListener_, $$7: boolean, $$8: number, $$9: Internal.List_<any>, $$10: boolean, $$11: Internal.RandomSequences_)
        spawnLightning(x: number, y: number, z: number, effectOnly: boolean, player: Internal.ServerPlayer_): void;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        resetEmptyTime(): void;
        setDefaultSpawnPos($$0: BlockPos_, $$1: number): void;
        getPlayers($$0: Internal.Predicate_<Internal.ServerPlayer>, $$1: number): Internal.List<Internal.ServerPlayer>;
        tick($$0: Internal.BooleanSupplier_): void;
        handler$hpo000$sophisticatedcore$addEntityEvent(serverPlayer: Internal.ServerPlayer_, ci: Internal.CallbackInfo_): void;
        isEmptyBlock($$0: BlockPos_): boolean;
        handler$zkf000$ae2$preventChunkUnforcing(chunkX: number, chunkZ: number, add: boolean, cir: Internal.CallbackInfoReturnable_<any>): void;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        addRespawnedPlayer($$0: Internal.ServerPlayer_): void;
        runCommandSilent(command: string): number;
        asComponentProvider(): Internal.ComponentProvider;
        addWorldGenChunkEntities($$0: Internal.Stream_<Internal.Entity>): void;
        sendParticles<T extends Internal.ParticleOptions>($$0: Internal.ServerPlayer_, $$1: T, $$2: boolean, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number): boolean;
        fabric_registerCache(pos: BlockPos_, cache: Internal.BlockApiCacheImpl_<any, any>): void;
        getRaidAt($$0: BlockPos_): Internal.Raid;
        getDataStorage(): Internal.DimensionDataStorage;
        ensureCanWrite($$0: BlockPos_): boolean;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        getPersistentData(): Internal.CompoundTag;
        getPlayers($$0: Internal.Predicate_<Internal.ServerPlayer>): Internal.List<Internal.ServerPlayer>;
        getEntityManager(): Internal.PersistentEntitySectionManager<any>;
        getFluidTicks(): Internal.LevelTickAccess<any>;
        addDuringTeleport($$0: Internal.Entity_): void;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        isNaturalSpawningAllowed($$0: Internal.ChunkPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isPositionEntityTicking($$0: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        getRandomSequences(): Internal.RandomSequences;
        setTime(time: number): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        isNaturalSpawningAllowed($$0: BlockPos_): boolean;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        setWeatherParameters($$0: number, $$1: number, $$2: boolean, $$3: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getPortalForcer(): Internal.PortalForcer;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        isVillage($$0: Internal.SectionPos_): boolean;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getName(): net.minecraft.network.chat.Component;
        getDifficulty(): Internal.Difficulty;
        getForcedChunks(): Internal.LongSet;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        phaseBlock(pos: BlockPos_, ticks: number): void;
        getFluidTicks(): Internal.LevelTicks<Internal.Fluid>;
        getEntities<T extends Internal.Entity>($$0: Internal.EntityTypeTest_<Internal.Entity, T>, $$1: Internal.Predicate_<T>, $$2: Internal.List_<T>, $$3: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        hasChunk($$0: number, $$1: number): boolean;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getMoonBrightness(): number;
        /**
         * @deprecated
        */
        setDragonFight($$0: Internal.EndDragonFight_): void;
        isWaterAt($$0: BlockPos_): boolean;
        saveDebugReport($$0: Internal.Path_): void;
        static getAllLoadedEntities(level: Internal.Level_): Internal.Iterable<Internal.Entity>;
        getSide(): Internal.ScriptType;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        getChunkSource(): Internal.ServerChunkCache;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        remaskPhasedBlocks(): void;
        getStructureManager(): Internal.StructureTemplateManager;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getRecipientsForComponentSync(): Internal.Iterable<any>;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        removePlayerImmediately($$0: Internal.ServerPlayer_, $$1: Internal.Entity$RemovalReason_): void;
        getPoiManager(): Internal.PoiManager;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        static makeObsidianPlatform($$0: Internal.ServerLevel_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        getMaxLightLevel(): number;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        isConsistent(): boolean;
        tickNonPassenger($$0: Internal.Entity_): void;
        getSeed(): number;
        handler$zie000$ad_astra$tickChunk(chunk: Internal.LevelChunk_, randomTickSpeed: number, ci: Internal.CallbackInfo_): void;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        save($$0: Internal.ProgressListener_, $$1: boolean, $$2: boolean): void;
        addWithUUID($$0: Internal.Entity_): boolean;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getAllEntities(): Internal.Iterable<Internal.Entity>;
        fabric_invalidateCache(pos: BlockPos_): void;
        sendParticles($$0: Internal.ServerPlayer_, $$1: boolean, $$2: number, $$3: number, $$4: number, $$5: Internal.Packet_<any>): boolean;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        unload($$0: Internal.LevelChunk_): void;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        canSleepThroughNights(): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        onReputationEvent($$0: Internal.ReputationEventType_, $$1: Internal.Entity_, $$2: Internal.ReputationEventHandler_): void;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        setDayTime($$0: number): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getDisplayName(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        getDirectSignalTo($$0: BlockPos_): number;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        areEntitiesLoaded($$0: number): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        tryAddFreshEntityWithPassengers($$0: Internal.Entity_): boolean;
        spawnLightning(x: number, y: number, z: number, effectOnly: boolean): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        setChunkForced($$0: number, $$1: number, $$2: boolean): boolean;
        mfix$getStrongholdCache(): Internal.StrongholdLocationCache;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        addDuringCommandTeleport($$0: Internal.ServerPlayer_): void;
        startTickingChunk($$0: Internal.LevelChunk_): void;
        getBlockTicks(): Internal.LevelTickAccess<any>;
        getWatchdogStats(): string;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        findClosestBiome3d($$0: Internal.Predicate_<Internal.Holder<Internal.Biome>>, $$1: BlockPos_, $$2: number, $$3: number, $$4: number): com.mojang.datafixers.util.Pair<BlockPos, Internal.Holder<Internal.Biome>>;
        isCloseToVillage($$0: BlockPos_, $$1: number): boolean;
        setNavigationActive(mobEntity: Internal.Mob_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getRandomSequence($$0: ResourceLocation_): Internal.RandomSource;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        handler$dak000$glitchcore$onAddPlayer(player: Internal.ServerPlayer_, ci: Internal.CallbackInfo_): void;
        tickCustomSpawners($$0: boolean, $$1: boolean): void;
        getScoreboard(): Internal.ServerScoreboard;
        addNewPlayer($$0: Internal.ServerPlayer_): void;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        modifyReturnValue$gfg000$porting_lib_entity$port_lib$getMultipart(entity: Internal.Entity_, id: number): Internal.Entity;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getEntities<T extends Internal.Entity>($$0: Internal.EntityTypeTest_<Internal.Entity, T>, $$1: Internal.Predicate_<T>, $$2: Internal.List_<T>): void;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        isPhased(pos: BlockPos_): boolean;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        sendParticles<T extends Internal.ParticleOptions>($$0: T, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isHandlingTick(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getBlockTicks(): Internal.LevelTicks<Internal.Block>;
        getDimension(): ResourceLocation;
        canSeeSky($$0: BlockPos_): boolean;
        handler$zie000$ad_astra$adastra$tick(hasTimeLeft: Internal.BooleanSupplier_, ci: Internal.CallbackInfo_): void;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        unmaskPhasedBlocks(): void;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        /**
         * @deprecated
        */
        getEntityOrPart($$0: number): Internal.Entity;
        getDragons(): Internal.List<Internal.EnderDragon>;
        addFreshEntityWithPassengers($$0: Internal.Entity_): void;
        structureManager(): Internal.StructureManager;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        abstract adastra$getParts(): Internal.Int2ObjectMap<Internal.Entity>;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        mfix$getSafeBlockGetter(): Internal.SafeBlockGetter;
        updateSleepingPlayerList(): void;
        getRandomPlayer(): Internal.ServerPlayer;
        noCollision($$0: Internal.Entity_): boolean;
        getLevel(): this;
        setNavigationInactive(mobEntity: Internal.Mob_): void;
        tickChunk($$0: Internal.LevelChunk_, $$1: number): void;
        self(): Internal.Level;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        getBestNeighborSignal($$0: BlockPos_): number;
        getEntity($$0: Internal.UUID_): Internal.Entity;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number, customSrc: DamageSource_): void;
        sectionsToVillage($$0: Internal.SectionPos_): number;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        handler$zie000$ad_astra$adastra$init(server: Internal.MinecraftServer_, dispatcher: Internal.Executor_, levelStorageAccess: Internal.LevelStorageSource$LevelStorageAccess_, serverLevelData: Internal.ServerLevelData_, dimension: Internal.ResourceKey_<any>, levelStem: Internal.LevelStem_, progressListener: Internal.ChunkProgressListener_, isDebug: boolean, biomeZoomSeed: number, customSpawners: Internal.List_<any>, tickTime: boolean, randomSequences: Internal.RandomSequences_, ci: Internal.CallbackInfo_): void;
        noCollision($$0: Internal.AABB_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        handler$gfg000$porting_lib_entity$port_lib$addEntityEvent(serverPlayer: Internal.ServerPlayer_, ci: Internal.CallbackInfo_): void;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        clearBlockEvents($$0: Internal.BoundingBox_): void;
        setCurrentlyGenerating($$0: Internal.Supplier_<string>): void;
        findNearestMapStructure($$0: Internal.TagKey_<Internal.Structure>, $$1: BlockPos_, $$2: number, $$3: boolean): BlockPos;
        create$getEntityTickList(): Internal.EntityTickList;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        getEntities(): Internal.EntityArrayList;
        spawnParticles(options: Internal.ParticleOptions_, overrideLimiter: boolean, x: number, y: number, z: number, vx: number, vy: number, vz: number, count: number, speed: number): void;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        addDuringPortalTeleport($$0: Internal.ServerPlayer_): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getPartEntityMap(): Internal.Int2ObjectMap<Internal.PartEntity<any>>;
        getLogicalHeight(): number;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        onStructureStartsAvailable($$0: Internal.ChunkAccess_): void;
        isRaided($$0: BlockPos_): boolean;
        addLegacyChunkEntities($$0: Internal.Stream_<Internal.Entity>): void;
        getRaids(): Internal.Raids;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        isVillage($$0: BlockPos_): boolean;
        getPlayers(): Internal.EntityArrayList;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number): void;
        getDragonFight(): Internal.EndDragonFight;
        hasBiomes(): boolean;
        isOverworld(): boolean;
        runCommand(command: string): number;
        getEntities<T extends Internal.Entity>($$0: Internal.EntityTypeTest_<Internal.Entity, T>, $$1: Internal.Predicate_<T>): Internal.List<T>;
        isFlat(): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        get dataStorage(): Internal.DimensionDataStorage
        get persistentData(): Internal.CompoundTag
        get entityManager(): Internal.PersistentEntitySectionManager<any>
        get fluidTicks(): Internal.LevelTickAccess<any>
        get randomSequences(): Internal.RandomSequences
        set time(time: number)
        get portalForcer(): Internal.PortalForcer
        get name(): net.minecraft.network.chat.Component
        get difficulty(): Internal.Difficulty
        get forcedChunks(): Internal.LongSet
        get fluidTicks(): Internal.LevelTicks<Internal.Fluid>
        get moonBrightness(): number
        /**
         * @deprecated
        */
        set dragonFight($$0: Internal.EndDragonFight_)
        get side(): Internal.ScriptType
        get chunkSource(): Internal.ServerChunkCache
        get structureManager(): Internal.StructureTemplateManager
        get recipientsForComponentSync(): Internal.Iterable<any>
        get poiManager(): Internal.PoiManager
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get maxLightLevel(): number
        get consistent(): boolean
        get seed(): number
        get allEntities(): Internal.Iterable<Internal.Entity>
        set dayTime($$0: number)
        get displayName(): net.minecraft.network.chat.Component
        get blockTicks(): Internal.LevelTickAccess<any>
        get watchdogStats(): string
        set navigationActive(mobEntity: Internal.Mob_)
        get scoreboard(): Internal.ServerScoreboard
        get handlingTick(): boolean
        get blockTicks(): Internal.LevelTicks<Internal.Block>
        get dimension(): ResourceLocation
        get moonPhase(): number
        get dragons(): Internal.List<Internal.EnderDragon>
        get randomPlayer(): Internal.ServerPlayer
        get level(): Internal.ServerLevel
        set navigationInactive(mobEntity: Internal.Mob_)
        set currentlyGenerating($$0: Internal.Supplier_<string>)
        get entities(): Internal.EntityArrayList
        get partEntityMap(): Internal.Int2ObjectMap<Internal.PartEntity<any>>
        get logicalHeight(): number
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>
        get raids(): Internal.Raids
        get players(): Internal.EntityArrayList
        get dragonFight(): Internal.EndDragonFight
        get overworld(): boolean
        get flat(): boolean
        static readonly RAIN_DURATION: Internal.UniformInt;
        static readonly END_SPAWN_POINT: BlockPos;
        static readonly THUNDER_DURATION: Internal.UniformInt;
        noSave: boolean;
        readonly serverLevelData: Internal.ServerLevelData;
        static readonly RAIN_DELAY: Internal.UniformInt;
        entityManager: Internal.PersistentEntitySectionManager<Internal.Entity>;
    }
    type ServerLevel_ = ServerLevel;
    class DuckItem extends Internal.BlockItem implements Internal.DyeableLeatherItem {
        constructor(block: Internal.Block_, settings: Internal.Item$Properties_)
        hasRepairCost(stack: Internal.ItemStack_): boolean;
        static getDuckItemStack(color: number): Internal.ItemStack;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getColor(stack: Internal.ItemStack_): number;
        getRepairCost(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly DEFAULT_COLOR: 16701501;
    }
    type DuckItem_ = DuckItem;
    interface CustomMapData <H extends Internal.CustomMapData$DirtyCounter> {
        abstract loadUpdateTag(arg0: Internal.CompoundTag_): void;
        onItemTooltip(data: Internal.MapItemSavedData_, stack: Internal.ItemStack_): net.minecraft.network.chat.Component;
        onItemUpdate(data: Internal.MapItemSavedData_, entity: Internal.Entity_): boolean;
        abstract load(arg0: Internal.CompoundTag_): void;
        abstract saveToUpdateTag(arg0: Internal.CompoundTag_, arg1: H): void;
        setDirty(data: Internal.MapItemSavedData_, dirtySetter: Internal.Consumer_<H>): void;
        abstract createDirtyCounter(): H;
        persistOnRescale(): boolean;
        abstract save(arg0: Internal.CompoundTag_): void;
        abstract getType(): Internal.CustomMapData$Type<any>;
        persistOnCopyOrLock(): boolean;
        get type(): Internal.CustomMapData$Type<any>
    }
    type CustomMapData_<H extends Internal.CustomMapData$DirtyCounter> = CustomMapData<H>;
    class NoOpFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type NoOpFeature_ = NoOpFeature;
    interface NamedNodeMap {
        abstract setNamedItem(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract removeNamedItemNS(arg0: string, arg1: string): org.w3c.dom.Node;
        abstract getNamedItemNS(arg0: string, arg1: string): org.w3c.dom.Node;
        abstract removeNamedItem(arg0: string): org.w3c.dom.Node;
        abstract setNamedItemNS(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNamedItem(arg0: string): org.w3c.dom.Node;
        abstract item(arg0: number): org.w3c.dom.Node;
        abstract getLength(): number;
        set namedItem(arg0: org.w3c.dom.Node_)
        set namedItemNS(arg0: org.w3c.dom.Node_)
        get length(): number
    }
    type NamedNodeMap_ = NamedNodeMap;
    class LootDataId <T> extends Internal.Record {
        constructor($$0: Internal.LootDataType_<T>, $$1: ResourceLocation_)
        location(): ResourceLocation;
        type(): Internal.LootDataType<T>;
    }
    type LootDataId_<T> = LootDataId<T>;
    class CombinedIngredient$Deserializer implements Internal.IngredientDeserializer {
        constructor()
        fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.Ingredient;
        static init(): void;
        static tryDeserializeJson(object: Internal.JsonObject_): Internal.Ingredient;
        fromJson(object: Internal.JsonObject_): Internal.Ingredient;
        static tryDeserializeNetwork(buf: Internal.FriendlyByteBuf_): Internal.Ingredient;
        static readonly INSTANCE: Internal.CombinedIngredient$Deserializer;
        static readonly ID: ResourceLocation;
    }
    type CombinedIngredient$Deserializer_ = CombinedIngredient$Deserializer;
    class GearboxBlockEntity extends Internal.DirectionalShaftHalvesBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type GearboxBlockEntity_ = GearboxBlockEntity;
    class LevelStorageSource$LevelStorageAccess implements Internal.AutoCloseable {
        "handler$cif000$fabric-registry-sync-v0$readWorldProperties"(callbackInfo: Internal.CallbackInfoReturnable_<any>): void;
        deleteLevel(): void;
        getLevelPath($$0: Internal.LevelResource_): Internal.Path;
        getLevelId(): string;
        saveDataTag($$0: Internal.RegistryAccess_, $$1: Internal.WorldData_, $$2: Internal.CompoundTag_): void;
        "handler$cif000$fabric-registry-sync-v0$saveWorld"(registryTracker: Internal.RegistryAccess_, saveProperties: Internal.WorldData_, compoundTag: Internal.CompoundTag_, info: Internal.CallbackInfo_): void;
        getDataConfiguration(): Internal.WorldDataConfiguration;
        getSummary(): Internal.LevelSummary;
        makeWorldBackup(): number;
        getDimensionPath($$0: Internal.ResourceKey_<Internal.Level>): Internal.Path;
        getDataTag($$0: Internal.DynamicOps_<Internal.Tag>, $$1: Internal.WorldDataConfiguration_, $$2: Internal.Registry_<Internal.LevelStem>, $$3: Internal.Lifecycle_): com.mojang.datafixers.util.Pair<Internal.WorldData, Internal.WorldDimensions$Complete>;
        renameLevel($$0: string): void;
        close(): void;
        saveDataTag($$0: Internal.RegistryAccess_, $$1: Internal.WorldData_): void;
        createPlayerStorage(): Internal.PlayerDataStorage;
        getIconFile(): Internal.Optional<Internal.Path>;
        get levelId(): string
        get dataConfiguration(): Internal.WorldDataConfiguration
        get summary(): Internal.LevelSummary
        get iconFile(): Internal.Optional<Internal.Path>
    }
    type LevelStorageSource$LevelStorageAccess_ = LevelStorageSource$LevelStorageAccess;
    interface GenericDeclaration extends Internal.AnnotatedElement {
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        abstract getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        abstract getAnnotations(): Internal.Annotation[];
        abstract getTypeParameters(): any[];
        abstract getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        get annotations(): Internal.Annotation[]
        get typeParameters(): any[]
        get declaredAnnotations(): Internal.Annotation[]
    }
    type GenericDeclaration_ = GenericDeclaration;
    interface BiomeSeedProvider {
        getBiomeSeed(world: Internal.ClientLevel_): number;
        abstract sodium$getBiomeSeed(): number;
        (): number;
    }
    type BiomeSeedProvider_ = BiomeSeedProvider;
    interface SimpleRegistry$Multi <K, V> extends Internal.SimpleRegistry<K, Internal.List<V>> {
        abstract register(arg0: K, arg1: Internal.List_<V>): void;
        get(arg0: Internal.StateHolder_<any, any>): any;
        abstract add(arg0: K, arg1: V): void;
        create<K, V>(): this;
        abstract addProvider(arg0: Internal.SimpleRegistry$Provider_<K, V>): void;
        abstract invalidate(): void;
        get(arg0: any): any;
        abstract registerProvider(arg0: Internal.SimpleRegistry$Provider_<K, Internal.List<V>>): void;
    }
    type SimpleRegistry$Multi_<K, V> = SimpleRegistry$Multi<K, V>;
    abstract class MultifaceBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static pack($$0: Internal.Collection_<Internal.Direction>): number;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static availableFaces($$0: Internal.BlockState_): Internal.Set<Internal.Direction>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static getFaceProperty($$0: Internal.Direction_): Internal.BooleanProperty;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        abstract getSpreader(): Internal.MultifaceSpreader;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        isValidStateForPlacement($$0: Internal.BlockGetter_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: Internal.Direction_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getStateForPlacement($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_): Internal.BlockState;
        emi(): Internal.EmiStack;
        static canAttachTo($$0: Internal.BlockGetter_, $$1: Internal.Direction_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        static unpack($$0: number): Internal.Set<Internal.Direction>;
        static hasFace($$0: Internal.BlockState_, $$1: Internal.Direction_): boolean;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get spreader(): Internal.MultifaceSpreader
        set destroySpeed(v: number)
    }
    type MultifaceBlock_ = MultifaceBlock;
    class MoltenZincFluid$Source extends Internal.MoltenZincFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenZincFluid$Source_ = MoltenZincFluid$Source;
    class Explosion implements Internal.ExplosionHooksImpl$ExplosionExtensions {
        constructor($$0: Internal.Level_, $$1: Internal.Entity_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: Internal.Explosion$BlockInteraction_)
        constructor($$0: Internal.Level_, $$1: Internal.Entity_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: Internal.Explosion$BlockInteraction_, $$8: Internal.List_<BlockPos>)
        constructor($$0: Internal.Level_, $$1: Internal.Entity_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.List_<BlockPos>)
        constructor($$0: Internal.Level_, $$1: Internal.Entity_, $$2: DamageSource_, $$3: Internal.ExplosionDamageCalculator_, $$4: number, $$5: number, $$6: number, $$7: number, $$8: boolean, $$9: Internal.Explosion$BlockInteraction_)
        constant$emn000$lithium$skipLoop(prevValue: number): number;
        getDamageSource(): DamageSource;
        handler$zbn000$porting_lib_base$onExplode(ci: Internal.CallbackInfo_, blocks: Internal.Set_<any>, i: number, j: number, k: number, l: number, d: number, q: number, e: number, r: number, list: Internal.List_<any>): void;
        getIndirectSourceEntity(): Internal.LivingEntity;
        getDirectSourceEntity(): Internal.Entity;
        finalizeExplosion($$0: boolean): void;
        explode(): void;
        redirect$emn000$lithium$skipNewHashSet(): Internal.HashSet<any>;
        redirect$emn000$lithium$collectBlocks(affectedBlocks: Internal.ObjectArrayList_<any>, collection: Internal.Collection_<any>): boolean;
        interactsWithBlocks(): boolean;
        getToBlow(): Internal.List<BlockPos>;
        architectury_getPosition(): Vec3d;
        static getSeenPercent($$0: Vec3d_, $$1: Internal.Entity_): number;
        clearToBlow(): void;
        getHitPlayers(): Internal.Map<Internal.Player, Vec3d>;
        get damageSource(): DamageSource
        get indirectSourceEntity(): Internal.LivingEntity
        get directSourceEntity(): Internal.Entity
        get toBlow(): Internal.List<BlockPos>
        get hitPlayers(): Internal.Map<Internal.Player, Vec3d>
        readonly z: number;
        blockInteraction: Internal.Explosion$BlockInteraction;
        radius: number;
        readonly level: Internal.Level;
        source: Internal.Entity;
        readonly toBlow: Internal.ObjectArrayList<BlockPos>;
        damageSource: DamageSource;
        readonly damageCalculator: Internal.ExplosionDamageCalculator;
        readonly x: number;
        readonly y: number;
    }
    type Explosion_ = Explosion;
    interface LongConsumer {
        andThen(arg0: Internal.LongConsumer_): this;
        abstract accept(arg0: number): void;
        (arg0: number): void;
    }
    type LongConsumer_ = LongConsumer;
    interface DocumentType extends org.w3c.dom.Node {
        abstract getPrefix(): string;
        abstract getFirstChild(): org.w3c.dom.Node;
        abstract getLastChild(): org.w3c.dom.Node;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract getInternalSubset(): string;
        abstract cloneNode(arg0: boolean): org.w3c.dom.Node;
        abstract normalize(): void;
        abstract getOwnerDocument(): Internal.Document;
        abstract hasChildNodes(): boolean;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract hasAttributes(): boolean;
        abstract removeChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNodeValue(): string;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract appendChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNamespaceURI(): string;
        abstract getLocalName(): string;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getName(): string;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): org.w3c.dom.Node;
        abstract lookupPrefix(arg0: string): string;
        abstract setPrefix(arg0: string): void;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getPublicId(): string;
        abstract getTextContent(): string;
        abstract getChildNodes(): Internal.NodeList;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract getSystemId(): string;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract getNodeType(): number;
        abstract setNodeValue(arg0: string): void;
        abstract getNotations(): Internal.NamedNodeMap;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract getNextSibling(): org.w3c.dom.Node;
        abstract getUserData(arg0: string): any;
        abstract getEntities(): Internal.NamedNodeMap;
        abstract getParentNode(): org.w3c.dom.Node;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        get prefix(): string
        get firstChild(): org.w3c.dom.Node
        get lastChild(): org.w3c.dom.Node
        get internalSubset(): string
        get ownerDocument(): Internal.Document
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        get namespaceURI(): string
        get localName(): string
        get name(): string
        get previousSibling(): org.w3c.dom.Node
        set prefix(arg0: string)
        get publicId(): string
        get textContent(): string
        get childNodes(): Internal.NodeList
        get attributes(): Internal.NamedNodeMap
        get systemId(): string
        get nodeType(): number
        set nodeValue(arg0: string)
        get notations(): Internal.NamedNodeMap
        get baseURI(): string
        get nextSibling(): org.w3c.dom.Node
        get entities(): Internal.NamedNodeMap
        get parentNode(): org.w3c.dom.Node
    }
    type DocumentType_ = DocumentType;
    interface IActionHost {
        abstract getActionableNode(): Internal.IGridNode;
        get actionableNode(): Internal.IGridNode
        (): Internal.IGridNode_;
    }
    type IActionHost_ = IActionHost;
    abstract class Model {
        constructor($$0: Internal.Function_<ResourceLocation, Internal.RenderType>)
        renderType($$0: ResourceLocation_): Internal.RenderType;
        abstract renderToBuffer(arg0: Internal.PoseStack_, arg1: Internal.VertexConsumer_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): void;
    }
    type Model_ = Model;
    class ClientboundContainerSetContentPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number, $$2: Internal.NonNullList_<Internal.ItemStack>, $$3: Internal.ItemStack_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getStateId(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getCarriedItem(): Internal.ItemStack;
        getContainerId(): number;
        isSkippable(): boolean;
        getItems(): Internal.List<Internal.ItemStack>;
        get stateId(): number
        get carriedItem(): Internal.ItemStack
        get containerId(): number
        get skippable(): boolean
        get items(): Internal.List<Internal.ItemStack>
    }
    type ClientboundContainerSetContentPacket_ = ClientboundContainerSetContentPacket;
    class BlockBooleanDirectrix extends Internal.BlockCircleComponent {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STATE: Internal.EnumProperty<Internal.BlockBooleanDirectrix$State>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockBooleanDirectrix_ = BlockBooleanDirectrix;
    class Class <T> implements Internal.Constable, Internal.Type, Internal.TypeDescriptor$OfField<typeof any>, Internal.Serializable, Internal.AnnotatedElement, Internal.GenericDeclaration {
        isPrimitive(): boolean;
        getTypeName(): string;
        isAnnotation(): boolean;
        getConstructors(): Internal.Constructor<any>[];
        isInstance(arg0: any): boolean;
        getModifiers(): number;
        static forName(arg0: Internal.Module_, arg1: string): typeof any;
        getDeclaredMethod(arg0: string, ...arg1: typeof any[]): Internal.Method;
        getEnumConstants(): T[];
        getAnnotation<A extends Internal.Annotation>(arg0: A): A;
        getAnnotatedSuperclass(): Internal.AnnotatedType;
        arrayType(): typeof any;
        getRecordComponents(): any[];
        getDeclaredField(arg0: string): Internal.Field;
        getClassLoader(): Internal.ClassLoader;
        getPackageName(): string;
        static forName(arg0: string): typeof any;
        getAnnotatedInterfaces(): Internal.AnnotatedType[];
        getDeclaredFields(): Internal.Field[];
        asSubclass<U>(arg0: U): U;
        getResourceAsStream(arg0: string): Internal.InputStream;
        isLocalClass(): boolean;
        getDeclaredAnnotationsByType<A extends Internal.Annotation>(arg0: A): A[];
        getProtectionDomain(): Internal.ProtectionDomain;
        cast(arg0: any): T;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        isAnonymousClass(): boolean;
        isUnnamedClass(): boolean;
        getGenericSuperclass(): Internal.Type;
        getDeclaredConstructor(...arg0: typeof any[]): Internal.Constructor<T>;
        getMethods(): Internal.Method[];
        isNestmateOf(arg0: typeof any): boolean;
        isInterface(): boolean;
        getSuperclass(): this;
        getField(arg0: string): Internal.Field;
        getTypeParameters(): any[];
        getModule(): Internal.Module;
        toGenericString(): string;
        getFields(): Internal.Field[];
        isAssignableFrom(arg0: typeof any): boolean;
        getComponentType(): typeof any;
        componentType(): Internal.TypeDescriptor$OfField<any>;
        getGenericInterfaces(): Internal.Type[];
        getEnclosingMethod(): Internal.Method;
        getEnclosingConstructor(): Internal.Constructor<any>;
        getNestMembers(): typeof any[];
        descriptorString(): string;
        /**
         * @deprecated
        */
        newInstance(): T;
        isRecord(): boolean;
        isArray(): boolean;
        getName(): string;
        describeConstable(): Internal.Optional<Internal.ClassDesc>;
        isSealed(): boolean;
        getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        isMemberClass(): boolean;
        getDeclaredConstructors(): Internal.Constructor<any>[];
        getCanonicalName(): string;
        getClasses(): typeof any[];
        isHidden(): boolean;
        isSynthetic(): boolean;
        getEnclosingClass(): typeof any;
        getInterfaces(): typeof any[];
        getSimpleName(): string;
        getMethod(arg0: string, ...arg1: typeof any[]): Internal.Method;
        getDeclaringClass(): typeof any;
        desiredAssertionStatus(): boolean;
        getSigners(): any[];
        static forName(arg0: string, arg1: boolean, arg2: Internal.ClassLoader_): typeof any;
        getPackage(): Internal.Package;
        getDeclaredMethods(): Internal.Method[];
        getConstructor(...arg0: typeof any[]): Internal.Constructor<T>;
        isEnum(): boolean;
        getPermittedSubclasses(): typeof any[];
        getAnnotations(): Internal.Annotation[];
        getNestHost(): typeof any;
        getDeclaredAnnotation<A extends Internal.Annotation>(arg0: A): A;
        getResource(arg0: string): Internal.URL;
        getDeclaredClasses(): typeof any[];
        getAnnotationsByType<A extends Internal.Annotation>(arg0: A): A[];
        get primitive(): boolean
        get typeName(): string
        get annotation(): boolean
        get constructors(): Internal.Constructor<any>[]
        get modifiers(): number
        get enumConstants(): T[]
        get annotatedSuperclass(): Internal.AnnotatedType
        get recordComponents(): any[]
        get classLoader(): Internal.ClassLoader
        get packageName(): string
        get annotatedInterfaces(): Internal.AnnotatedType[]
        get declaredFields(): Internal.Field[]
        get localClass(): boolean
        get protectionDomain(): Internal.ProtectionDomain
        get anonymousClass(): boolean
        get unnamedClass(): boolean
        get genericSuperclass(): Internal.Type
        get methods(): Internal.Method[]
        get "interface"(): boolean
        get superclass(): T
        get typeParameters(): any[]
        get module(): Internal.Module
        get fields(): Internal.Field[]
        get componentType(): typeof any
        get genericInterfaces(): Internal.Type[]
        get enclosingMethod(): Internal.Method
        get enclosingConstructor(): Internal.Constructor<any>
        get nestMembers(): typeof any[]
        get record(): boolean
        get array(): boolean
        get name(): string
        get sealed(): boolean
        get declaredAnnotations(): Internal.Annotation[]
        get memberClass(): boolean
        get declaredConstructors(): Internal.Constructor<any>[]
        get canonicalName(): string
        get classes(): typeof any[]
        get hidden(): boolean
        get synthetic(): boolean
        get enclosingClass(): typeof any
        get interfaces(): typeof any[]
        get simpleName(): string
        get declaringClass(): typeof any
        get signers(): any[]
        get "package"(): Internal.Package
        get declaredMethods(): Internal.Method[]
        get enum(): boolean
        get permittedSubclasses(): typeof any[]
        get annotations(): Internal.Annotation[]
        get nestHost(): typeof any
        get declaredClasses(): typeof any[]
    }
    type Class_<T> = Class<T>;
    class AddedByAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type AddedByAttribute$Type_ = AddedByAttribute$Type;
    class PackagerItemHandler extends Internal.SnapshotParticipant<Internal.Optional<Internal.ItemStack>> implements Internal.SingleSlotStorage<Internal.ItemVariant> {
        constructor(blockEntity: Internal.PackagerBlockEntity_)
        extract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        getUnderlyingView(): Internal.StorageView<Internal.ItemVariant>;
        supportsExtraction(): boolean;
        extract(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getAmount(): number;
        isResourceBlank(): boolean;
        getSlotCount(): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        getResource(): Internal.ItemVariant;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        insert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static asClass<T>(): Internal.Storage<T>;
        insert(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        getCapacity(): number;
        get underlyingView(): Internal.StorageView<Internal.ItemVariant>
        get amount(): number
        get resourceBlank(): boolean
        get slotCount(): number
        get resource(): Internal.ItemVariant
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
        get capacity(): number
    }
    type PackagerItemHandler_ = PackagerItemHandler;
    class BonePipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type BonePipeBlock_ = BonePipeBlock;
    class ItemSpellbook extends Internal.Item implements Internal.VariantItem, Internal.IotaHolderItem {
        constructor(properties: Internal.Item$Properties_)
        canWrite(stack: Internal.ItemStack_, datum: Internal.Iota_): boolean;
        writeable(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        writeDatum(stack: Internal.ItemStack_, datum: Internal.Iota_): void;
        static getPage(stack: Internal.ItemStack_, ifEmpty: number): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emptyIota(stack: Internal.ItemStack_): Internal.Iota;
        numVariants(): number;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getColor(stack: Internal.ItemStack_): number;
        getVariant(stack: Internal.ItemStack_): number;
        static arePagesEmpty(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        static highestPage(stack: Internal.ItemStack_): number;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static setSealed(stack: Internal.ItemStack_, sealed: boolean): void;
        readIotaTag(stack: Internal.ItemStack_): Internal.CompoundTag;
        static appendHoverText(self: Internal.IotaHolderItem_, stack: Internal.ItemStack_, components: Internal.List_<net.minecraft.network.chat.Component>, flag: Internal.TooltipFlag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static rotatePageIdx(stack: Internal.ItemStack_, increase: boolean): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        readIota(stack: Internal.ItemStack_, world: Internal.ServerLevel_): Internal.Iota;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setVariant(stack: Internal.ItemStack_, variant: number): void;
        static isSealed(stack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        clampVariant(variant: number): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static TAG_SEALED: "sealed_pages";
        static TAG_PAGE_NAMES: "page_names";
        static TAG_PAGES: "pages";
        static TAG_SELECTED_PAGE: "page_idx";
        static readonly TAG_VARIANT: "variant";
        static readonly MAX_PAGES: 64;
    }
    type ItemSpellbook_ = ItemSpellbook;
    class WideGaugeTrackBlock extends Internal.TrackBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, material: Internal.TrackMaterial_)
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackBlockEntity>): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackBlockEntity>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type WideGaugeTrackBlock_ = WideGaugeTrackBlock;
    interface AccessKeyMapping {
        abstract controlling$getKey(): Internal.InputConstants$Key;
        (): Internal.InputConstants$Key_;
    }
    type AccessKeyMapping_ = AccessKeyMapping;
    class HeightRangePlacement extends Internal.PlacementModifier implements Internal.HeightRangePlacementAccessor {
        getHeight(): Internal.HeightProvider;
        static uniform($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.HeightRangePlacement;
        static triangle($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.HeightRangePlacement;
        static of($$0: Internal.HeightProvider_): Internal.HeightRangePlacement;
        get height(): Internal.HeightProvider
        static readonly CODEC: Internal.Codec<Internal.HeightRangePlacement>;
    }
    type HeightRangePlacement_ = HeightRangePlacement;
    class ServerboundCommandSuggestionPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: string)
        handle(arg0: Internal.PacketListener_): void;
        getCommand(): string;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        getId(): number;
        get command(): string
        get skippable(): boolean
        get id(): number
    }
    type ServerboundCommandSuggestionPacket_ = ServerboundCommandSuggestionPacket;
    class StructureVoidBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type StructureVoidBlock_ = StructureVoidBlock;
    class CableBlockItem$Cable extends Internal.CableBlockItem {
        constructor(block: dan200.computercraft.shared.peripheral.modem.wired.CableBlock_, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CableBlockItem$Cable_ = CableBlockItem$Cable;
    interface Shapes$DoubleLineConsumer {
        abstract consume(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        (arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
    }
    type Shapes$DoubleLineConsumer_ = Shapes$DoubleLineConsumer;
    abstract class Team {
        constructor()
        abstract getDeathMessageVisibility(): Internal.Team$Visibility;
        abstract isAllowFriendlyFire(): boolean;
        abstract getFormattedName(arg0: net.minecraft.network.chat.Component_): Internal.MutableComponent;
        abstract getName(): string;
        isAlliedTo($$0: Internal.Team_): boolean;
        abstract getColor(): Internal.ChatFormatting;
        abstract getNameTagVisibility(): Internal.Team$Visibility;
        abstract getCollisionRule(): Internal.Team$CollisionRule;
        abstract canSeeFriendlyInvisibles(): boolean;
        abstract getPlayers(): Internal.Collection<string>;
        get deathMessageVisibility(): Internal.Team$Visibility
        get allowFriendlyFire(): boolean
        get name(): string
        get color(): Internal.ChatFormatting
        get nameTagVisibility(): Internal.Team$Visibility
        get collisionRule(): Internal.Team$CollisionRule
        get players(): Internal.Collection<string>
    }
    type Team_ = Team;
    class NormalNoise {
        parameters(): Internal.NormalNoise$NoiseParameters;
        getValue($$0: number, $$1: number, $$2: number): number;
        static create($$0: Internal.RandomSource_, $$1: Internal.NormalNoise$NoiseParameters_): Internal.NormalNoise;
        maxValue(): number;
        /**
         * @deprecated
        */
        static createLegacyNetherBiome($$0: Internal.RandomSource_, $$1: Internal.NormalNoise$NoiseParameters_): Internal.NormalNoise;
        static create($$0: Internal.RandomSource_, $$1: number, ...$$2: number[]): Internal.NormalNoise;
        parityConfigString($$0: Internal.StringBuilder_): void;
    }
    type NormalNoise_ = NormalNoise;
    interface FormattedText$ContentConsumer <T> {
        abstract accept(arg0: string): Internal.Optional<T>;
        (arg0: string): Internal.Optional_<T>;
    }
    type FormattedText$ContentConsumer_<T> = FormattedText$ContentConsumer<T>;
    abstract class AbstractClientPlayer extends Internal.Player implements Internal.AbstractClientPlayerAccessor, Internal.PlayerAnimations, Internal.ClientPlayerKJS {
        constructor($$0: Internal.ClientLevel_, $$1: Internal.GameProfile_)
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        abstract etf$getType(): Internal.EntityType<any>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        static getSkinLocation($$0: string): ResourceLocation;
        isCapeLoaded(): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        getEntityReach(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getXpLevel(): number;
        canReach(pos: BlockPos_, padding: number): boolean;
        clearMeshes(): void;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        isSkinLoaded(): boolean;
        paint(tag: Internal.CompoundTag_): void;
        getBlockReach(): number;
        damageHeldItem(): void;
        getDeltaMovementLerped($$0: number): Vec3d;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        isElytraLoaded(): boolean;
        attack(hp: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getAnimation(): Internal.AnimationApplier;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        static registerSkinTexture($$0: ResourceLocation_, $$1: string): void;
        getFoodLevel(): number;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        setXpLevel(l: number): void;
        canRiderInteract(): boolean;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        flywheel$getPlayerInfo(): Internal.PlayerInfo;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        canReach(entity: Internal.Entity_, padding: number): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        abstract etf$getArmorItems(): Internal.Iterable<Internal.ItemStack>;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        abstract etf$getItemsEquipped(): Internal.Iterable<Internal.ItemStack>;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        setXp(xp: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getModelName(): string;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        notify(notification: Notification_): void;
        isMonster(): boolean;
        sophisticatedCore_openMenu(menuProvider: Internal.MenuProvider_, pos: BlockPos_): Internal.OptionalInt;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        sophisticatedCore_openMenu(menu: Internal.MenuProvider_, context: Internal.Consumer_<Internal.FriendlyByteBuf>): Internal.OptionalInt;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getFieldOfViewModifier(): number;
        hexicalModAnimations(): Internal.ModifierLayer<any>;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        isCloseEnough(entity: Internal.Entity_, dist: number): boolean;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        give(item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getDigSpeed(state: Internal.BlockState_, pos: BlockPos_): number;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        getPlayerInfo(): Internal.PlayerInfo;
        setMotionX(x: number): void;
        getCloakTextureLocation(): ResourceLocation;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        isSelf(): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        canReach(entityHitVec: Vec3d_, padding: number): boolean;
        sendInventoryUpdate(): void;
        abstract etf$getHandItems(): Internal.Iterable<Internal.ItemStack>;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        getSkinTextureLocation(): ResourceLocation;
        getElytraTextureLocation(): ResourceLocation;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        static getPlayerModelParts(): Internal.EntityDataAccessor<number>;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get capeLoaded(): boolean
        get entityReach(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get skinLoaded(): boolean
        get blockReach(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get elytraLoaded(): boolean
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get animation(): Internal.AnimationApplier
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get modelName(): string
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get fieldOfViewModifier(): number
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        get playerInfo(): Internal.PlayerInfo
        set motionX(x: number)
        get cloakTextureLocation(): ResourceLocation
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get self(): boolean
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        get skinTextureLocation(): ResourceLocation
        get elytraTextureLocation(): ResourceLocation
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        get playerModelParts(): Internal.EntityDataAccessor<number>
        elytraRotX: number;
        elytraRotY: number;
        elytraRotZ: number;
        readonly clientLevel: Internal.ClientLevel;
    }
    type AbstractClientPlayer_ = AbstractClientPlayer;
    class DoubleMatrix implements Internal.Serializable {
        constructor()
        constructor(arg0: number, arg1: number)
        constructor(arg0: number, arg1: number, ...arg2: number[])
        constructor(arg0: number)
        constructor(arg0: number[])
        constructor(arg0: number[][])
        constructor(arg0: Internal.List_<number>)
        constructor(arg0: string)
        subiRowVector(arg0: Internal.DoubleMatrix_): this;
        sub(arg0: Internal.DoubleMatrix_): this;
        le(arg0: number): this;
        rsubi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        subi(arg0: number): this;
        out(arg0: Internal.DataOutputStream_): void;
        rdivi(arg0: Internal.DoubleMatrix_): this;
        put(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_, arg2: Internal.DoubleMatrix_): this;
        rowSortingPermutations(): number[][];
        ne(arg0: Internal.DoubleMatrix_): this;
        ori(arg0: number): this;
        checkLength(arg0: number): void;
        static zeros(arg0: number): Internal.DoubleMatrix;
        lei(arg0: number, arg1: Internal.DoubleMatrix_): this;
        get(arg0: number[], arg1: number[]): this;
        sorti(): this;
        rdiv(arg0: number): this;
        get(arg0: number[]): this;
        isVector(): boolean;
        add(arg0: number): this;
        put(arg0: Internal.DoubleMatrix_, arg1: number, arg2: number): this;
        getLength(): number;
        rdivi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        nei(arg0: number): this;
        lti(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        min(arg0: Internal.DoubleMatrix_): this;
        or(arg0: number): this;
        isUpperTriangular(): boolean;
        addColumnVector(arg0: Internal.DoubleMatrix_): this;
        muli(arg0: number): this;
        rsub(arg0: Internal.DoubleMatrix_): this;
        mean(): number;
        rsubi(arg0: Internal.DoubleMatrix_): this;
        checkRows(arg0: number): void;
        xor(arg0: number): this;
        lei(arg0: Internal.DoubleMatrix_): this;
        put(arg0: number, arg1: Internal.DoubleMatrix_, arg2: Internal.DoubleMatrix_): this;
        divRowVector(arg0: Internal.DoubleMatrix_): this;
        put(arg0: number, arg1: number, arg2: number): this;
        mulColumn(arg0: number, arg1: number): this;
        put(arg0: Internal.Range_, arg1: Internal.Range_, arg2: Internal.DoubleMatrix_): this;
        lt(arg0: number): this;
        isLowerTriangular(): boolean;
        columnArgmins(): number[];
        get(arg0: number): number;
        andi(arg0: number): this;
        rankOneUpdate(arg0: number, arg1: Internal.DoubleMatrix_, arg2: Internal.DoubleMatrix_): this;
        selecti(arg0: Internal.DoubleMatrix_): this;
        get(arg0: number[], arg1: number): this;
        toString(arg0: string): string;
        static logspace(arg0: number, arg1: number, arg2: number): Internal.DoubleMatrix;
        isSquare(): boolean;
        elementsAsList(): Internal.List<number>;
        rsubi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        mmuli(arg0: number, arg1: Internal.DoubleMatrix_): this;
        static linspace(arg0: number, arg1: number, arg2: number): Internal.DoubleMatrix;
        get(arg0: number, arg1: Internal.DoubleMatrix_): this;
        rdivi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        mmuli(arg0: Internal.DoubleMatrix_): this;
        divi(arg0: number): this;
        get(arg0: Internal.Range_, arg1: number): this;
        dup(): this;
        mini(arg0: number): this;
        sum(): number;
        ge(arg0: number): this;
        put(arg0: number[], arg1: number): this;
        static ones(arg0: number, arg1: number): Internal.DoubleMatrix;
        getRow(arg0: number, arg1: Internal.DoubleMatrix_): this;
        put(arg0: number[], arg1: number[], arg2: number): this;
        static diag(arg0: Internal.DoubleMatrix_): Internal.DoubleMatrix;
        max(arg0: Internal.DoubleMatrix_): this;
        lei(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        divi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        swapColumns(arg0: number, arg1: number): this;
        eq(arg0: number): this;
        and(arg0: number): this;
        gt(arg0: number): this;
        andi(arg0: Internal.DoubleMatrix_): this;
        diviColumnVector(arg0: Internal.DoubleMatrix_): this;
        getColumns(arg0: Internal.Range_, arg1: Internal.DoubleMatrix_): this;
        argmax(): number;
        rowsAsList(): Internal.List<Internal.DoubleMatrix>;
        dot(arg0: Internal.DoubleMatrix_): number;
        prod(): number;
        putRow(arg0: number, arg1: Internal.DoubleMatrix_): void;
        rsubi(arg0: number): this;
        static zeros(arg0: number, arg1: number): Internal.DoubleMatrix;
        mmul(arg0: Internal.DoubleMatrix_): this;
        scalar(): number;
        muliRowVector(arg0: Internal.DoubleMatrix_): this;
        compare(arg0: any, arg1: number): boolean;
        static diag(arg0: Internal.DoubleMatrix_, arg1: number, arg2: number): Internal.DoubleMatrix;
        put(arg0: number, arg1: number[], arg2: Internal.DoubleMatrix_): this;
        divi(arg0: Internal.DoubleMatrix_): this;
        toBooleanArray(): boolean[];
        subi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        get(arg0: Internal.DoubleMatrix_, arg1: number): this;
        toComplex(): Internal.ComplexDoubleMatrix;
        gei(arg0: number): this;
        get(arg0: Internal.Range_, arg1: Internal.Range_): this;
        truth(): this;
        sortRowsi(): this;
        distance1(arg0: Internal.DoubleMatrix_): number;
        assertSameSize(arg0: Internal.DoubleMatrix_): void;
        lti(arg0: number): this;
        diag(): this;
        muli(arg0: number, arg1: Internal.DoubleMatrix_): this;
        muli(arg0: Internal.DoubleMatrix_): this;
        static randn(arg0: number, arg1: number): Internal.DoubleMatrix;
        maxi(arg0: number): this;
        ne(arg0: number): this;
        select(arg0: Internal.DoubleMatrix_): this;
        gei(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        getRows(arg0: number[]): this;
        assertSquare(): void;
        andi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        gti(arg0: number): this;
        isColumnVector(): boolean;
        subi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        isEmpty(): boolean;
        columnSums(): this;
        assertMultipliesWith(arg0: Internal.DoubleMatrix_): void;
        put(arg0: Internal.DoubleMatrix_, arg1: number): this;
        columnMins(): this;
        findIndices(): number[];
        toBooleanArray2(): boolean[][];
        put(arg0: number[], arg1: number, arg2: number): this;
        static concatVertically(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): Internal.DoubleMatrix;
        columnArgmaxs(): number[];
        static concatHorizontally(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): Internal.DoubleMatrix;
        rowMaxs(): this;
        columnMeans(): this;
        indexRows(arg0: number): number;
        andi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        isRowVector(): boolean;
        static valueOf(arg0: string): Internal.DoubleMatrix;
        getRows(arg0: Internal.Range_): this;
        print(): void;
        norm1(): number;
        divi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        getRows(): number;
        toIntArray2(): number[][];
        min(arg0: number): this;
        div(arg0: number): this;
        muli(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        mini(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        multipliesWith(arg0: Internal.DoubleMatrix_): boolean;
        subi(arg0: Internal.DoubleMatrix_): this;
        rdivi(arg0: number): this;
        muliColumnVector(arg0: Internal.DoubleMatrix_): this;
        maxi(arg0: Internal.DoubleMatrix_): this;
        getColumn(arg0: number): this;
        reshape(arg0: number, arg1: number): this;
        addi(arg0: Internal.DoubleMatrix_): this;
        addiRowVector(arg0: Internal.DoubleMatrix_): this;
        argmin(): number;
        rsub(arg0: number): this;
        xori(arg0: number, arg1: Internal.DoubleMatrix_): this;
        sort(): this;
        isInfinitei(): this;
        xor(arg0: Internal.DoubleMatrix_): this;
        lei(arg0: number): this;
        gei(arg0: Internal.DoubleMatrix_): this;
        normmax(): number;
        xori(arg0: Internal.DoubleMatrix_): this;
        addi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        addRowVector(arg0: Internal.DoubleMatrix_): this;
        rowMeans(): this;
        mmuli(arg0: number): this;
        mul(arg0: Internal.DoubleMatrix_): this;
        mini(arg0: Internal.DoubleMatrix_): this;
        put(arg0: number[], arg1: Internal.DoubleMatrix_): this;
        neg(): this;
        norm2(): number;
        put(arg0: number[], arg1: number[], arg2: Internal.DoubleMatrix_): this;
        static scalar(arg0: number): Internal.DoubleMatrix;
        columnSortingPermutations(): number[][];
        getRowRange(arg0: number, arg1: number, arg2: number): this;
        div(arg0: Internal.DoubleMatrix_): this;
        subRowVector(arg0: Internal.DoubleMatrix_): this;
        mini(arg0: number, arg1: Internal.DoubleMatrix_): this;
        resize(arg0: number, arg1: number): void;
        subiColumnVector(arg0: Internal.DoubleMatrix_): this;
        getRows(arg0: Internal.DoubleMatrix_): this;
        static rand(arg0: number): Internal.DoubleMatrix;
        addi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        mmul(arg0: number): this;
        static randn(arg0: number): Internal.DoubleMatrix;
        save(arg0: string): void;
        rowArgmins(): number[];
        static rand(arg0: number, arg1: number): Internal.DoubleMatrix;
        maxi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        getColumnRange(arg0: number, arg1: number, arg2: number): this;
        static loadAsciiFile(arg0: string): Internal.DoubleMatrix;
        eqi(arg0: number): this;
        copy(arg0: Internal.DoubleMatrix_): this;
        gti(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        or(arg0: Internal.DoubleMatrix_): this;
        le(arg0: Internal.DoubleMatrix_): this;
        rdiv(arg0: Internal.DoubleMatrix_): this;
        getColumns(arg0: Internal.DoubleMatrix_): this;
        sameSize(arg0: Internal.DoubleMatrix_): boolean;
        divColumnVector(arg0: Internal.DoubleMatrix_): this;
        gei(arg0: number, arg1: Internal.DoubleMatrix_): this;
        static loadCSVFile(arg0: string): Internal.DoubleMatrix;
        mulRow(arg0: number, arg1: number): this;
        swapRows(arg0: number, arg1: number): this;
        sortColumnsi(): this;
        nei(arg0: Internal.DoubleMatrix_): this;
        xori(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        min(): number;
        subColumnVector(arg0: Internal.DoubleMatrix_): this;
        toString(arg0: string, arg1: string, arg2: string, arg3: string, arg4: string): string;
        rankOneUpdate(arg0: number, arg1: Internal.DoubleMatrix_): this;
        negi(): this;
        getRow(arg0: number): this;
        distance2(arg0: Internal.DoubleMatrix_): number;
        diviRowVector(arg0: Internal.DoubleMatrix_): this;
        index(arg0: number, arg1: number): number;
        put(arg0: Internal.DoubleMatrix_, arg1: number, arg2: Internal.DoubleMatrix_): this;
        max(arg0: number): this;
        static eye(arg0: number): Internal.DoubleMatrix;
        nei(arg0: number, arg1: Internal.DoubleMatrix_): this;
        mulRowVector(arg0: Internal.DoubleMatrix_): this;
        put(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        gti(arg0: Internal.DoubleMatrix_): this;
        eqi(arg0: Internal.DoubleMatrix_): this;
        indexColumns(arg0: number): number;
        getColumns(arg0: number[]): this;
        assertSameLength(arg0: Internal.DoubleMatrix_): void;
        cumulativeSumi(): this;
        put(arg0: number[], arg1: number, arg2: Internal.DoubleMatrix_): this;
        mmuli(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        rankOneUpdate(arg0: Internal.DoubleMatrix_): this;
        isScalar(): boolean;
        repmat(arg0: number, arg1: number): this;
        checkColumns(arg0: number): void;
        isInfinite(): this;
        columnsAsList(): Internal.List<Internal.DoubleMatrix>;
        isNaN(): this;
        mul(arg0: number): this;
        truthi(): this;
        put(arg0: number, arg1: number): this;
        transpose(): this;
        mulColumnVector(arg0: Internal.DoubleMatrix_): this;
        get(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        project(arg0: Internal.DoubleMatrix_): number;
        rowMins(): this;
        load(arg0: string): void;
        sameLength(arg0: Internal.DoubleMatrix_): boolean;
        toFloat(): Internal.FloatMatrix;
        ori(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        toArray(): number[];
        columnMaxs(): this;
        gti(arg0: number, arg1: Internal.DoubleMatrix_): this;
        sortColumns(): this;
        squaredDistance(arg0: Internal.DoubleMatrix_): number;
        getRange(arg0: number, arg1: number): this;
        get(arg0: number, arg1: number[]): this;
        get(arg0: number, arg1: Internal.Range_): this;
        put(arg0: number, arg1: Internal.DoubleMatrix_, arg2: number): this;
        toArray2(): number[][];
        sortingPermutation(): number[];
        fill(arg0: number): this;
        sub(arg0: number): this;
        ge(arg0: Internal.DoubleMatrix_): this;
        nei(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        getColumn(arg0: number, arg1: Internal.DoubleMatrix_): this;
        get(arg0: Internal.DoubleMatrix_): this;
        gt(arg0: Internal.DoubleMatrix_): this;
        getRows(arg0: Internal.Range_, arg1: Internal.DoubleMatrix_): this;
        ori(arg0: number, arg1: Internal.DoubleMatrix_): this;
        cumulativeSum(): this;
        isNaNi(): this;
        eqi(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        eq(arg0: Internal.DoubleMatrix_): this;
        rankOneUpdate(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_): this;
        toIntArray(): number[];
        addiColumnVector(arg0: Internal.DoubleMatrix_): this;
        rowArgmaxs(): number[];
        not(): this;
        "in"(arg0: Internal.DataInputStream_): void;
        and(arg0: Internal.DoubleMatrix_): this;
        sortRows(): this;
        put(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_, arg2: number): this;
        add(arg0: Internal.DoubleMatrix_): this;
        lt(arg0: Internal.DoubleMatrix_): this;
        maxi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        rowSums(): this;
        get(arg0: number, arg1: number): number;
        lti(arg0: number, arg1: Internal.DoubleMatrix_): this;
        xori(arg0: number): this;
        eqi(arg0: number, arg1: Internal.DoubleMatrix_): this;
        ori(arg0: Internal.DoubleMatrix_): this;
        noti(): this;
        put(arg0: number, arg1: number[], arg2: number): this;
        addi(arg0: number): this;
        getColumns(arg0: Internal.Range_): this;
        max(): number;
        getColumns(): number;
        static ones(arg0: number): Internal.DoubleMatrix;
        lti(arg0: Internal.DoubleMatrix_): this;
        getRange(arg0: number, arg1: number, arg2: number, arg3: number): this;
        putColumn(arg0: number, arg1: Internal.DoubleMatrix_): void;
        get vector(): boolean
        get length(): number
        get upperTriangular(): boolean
        get lowerTriangular(): boolean
        get square(): boolean
        get columnVector(): boolean
        get empty(): boolean
        get rowVector(): boolean
        get rows(): number
        get scalar(): boolean
        get columns(): number
        data: number[];
        length: number;
        static readonly EMPTY: Internal.DoubleMatrix;
        rows: number;
        columns: number;
    }
    type DoubleMatrix_ = DoubleMatrix;
    interface BuilderFactory {
        abstract createBuilder(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        (arg0: ResourceLocation): Internal.BuilderBase_<any>;
    }
    type BuilderFactory_ = BuilderFactory;
    interface SequencedSet <E> extends Internal.SequencedCollection<E>, Internal.Set<E> {
        addLast(arg0: E): void;
        getLast(): E;
        abstract add(arg0: E): boolean;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E): Internal.Set<E>;
        of<E>(): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        of<E>(...arg0: E[]): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        removeLast(): E;
        spliterator(): Internal.Spliterator<E>;
        abstract reversed(): this;
        abstract equals(arg0: any): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        get last(): E
        get empty(): boolean
        get first(): E
    }
    type SequencedSet_<E> = SequencedSet<E>;
    class MusicDiscItemBOP extends Internal.RecordItem {
        constructor(soundEvent: Internal.SoundEvent_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getByName(): Internal.Map<Internal.SoundEvent, Internal.RecordItem>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get byName(): Internal.Map<Internal.SoundEvent, Internal.RecordItem>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MusicDiscItemBOP_ = MusicDiscItemBOP;
    class AlternatorBlock extends Internal.DirectionalKineticBlock implements Internal.IRotate, Internal.IBE<Internal.AlternatorBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.AlternatorBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.AlternatorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.AlternatorBlockEntity>;
        getBlockEntityClass(): typeof Internal.AlternatorBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.AlternatorBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.AlternatorBlockEntity>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.AlternatorBlockEntity>
        get blockEntityClass(): typeof Internal.AlternatorBlockEntity
        static readonly ALTERNATOR_SHAPE: Internal.VoxelShaper;
    }
    type AlternatorBlock_ = AlternatorBlock;
    interface AccessorClientAdvancements {
        abstract bookshelf$getProgress(): Internal.Map<Internal.Advancement, Internal.AdvancementProgress>;
        (): Internal.Map_<Internal.Advancement, Internal.AdvancementProgress>;
    }
    type AccessorClientAdvancements_ = AccessorClientAdvancements;
    interface RegistrateLootTables extends Internal.LootTableSubProvider {
        abstract generate(arg0: Internal.BiConsumer_<ResourceLocation, Internal.LootTable$Builder>): void;
        validate(map: Internal.Map_<ResourceLocation, Internal.LootTable>, validationresults: Internal.ValidationContext_): void;
        (arg0: Internal.BiConsumer<ResourceLocation, Internal.LootTable$Builder>): void;
    }
    type RegistrateLootTables_ = RegistrateLootTables;
    /**
     * Invoked when a player opens a chest.
     * 
     * Same as `PlayerEvents.inventoryOpened`, but only for chests.
    */
    class ChestEventJS extends Internal.InventoryEventJS {
        constructor(player: Internal.Player_, menu: Internal.AbstractContainerMenu_)
        /**
         * Gets the chest inventory.
        */
        getInventory(): net.minecraft.world.Container;
        /**
         * Gets the player that opened or closed the container.
        */
        getEntity(): Internal.LivingEntity;
        /**
         * Gets the chest block.
        */
        getBlock(): Internal.BlockContainerJS;
        /**
         * Gets the chest inventory.
        */
        get inventory(): net.minecraft.world.Container
        /**
         * Gets the player that opened or closed the container.
        */
        get entity(): Internal.LivingEntity
        /**
         * Gets the chest block.
        */
        get block(): Internal.BlockContainerJS
    }
    type ChestEventJS_ = ChestEventJS;
    interface IOwnerAwareBlockEntity {
        abstract setOwner(arg0: Internal.Player_): void;
        set owner(arg0: Internal.Player_)
        (arg0: Internal.Player): void;
    }
    type IOwnerAwareBlockEntity_ = IOwnerAwareBlockEntity;
    class ZoneOffsetTransition implements Internal.Comparable<Internal.ZoneOffsetTransition>, Internal.Serializable {
        getOffsetAfter(): Internal.ZoneOffset;
        isValidOffset(arg0: Internal.ZoneOffset_): boolean;
        compareTo(arg0: Internal.ZoneOffsetTransition_): number;
        isGap(): boolean;
        compareTo(arg0: any): number;
        static of(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneOffset_, arg2: Internal.ZoneOffset_): Internal.ZoneOffsetTransition;
        isOverlap(): boolean;
        getDateTimeAfter(): Internal.LocalDateTime;
        getOffsetBefore(): Internal.ZoneOffset;
        getDuration(): Duration;
        toEpochSecond(): number;
        getDateTimeBefore(): Internal.LocalDateTime;
        getInstant(): Internal.Instant;
        get offsetAfter(): Internal.ZoneOffset
        get gap(): boolean
        get overlap(): boolean
        get dateTimeAfter(): Internal.LocalDateTime
        get offsetBefore(): Internal.ZoneOffset
        get duration(): Duration
        get dateTimeBefore(): Internal.LocalDateTime
        get instant(): Internal.Instant
    }
    type ZoneOffsetTransition_ = ZoneOffsetTransition;
    class KineticBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveHoveringInformation, Internal.IHaveGoggleInformation, Internal.CustomRenderBoundingBoxBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        clearKineticInformation(): void;
        static switchToBlockState(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        requestModelDataUpdate(): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        calculateStressApplied(): number;
        getGeneratedSpeed(): number;
        isCustomConnection(other: Internal.KineticBlockEntity_, state: Internal.BlockState_, otherState: Internal.BlockState_): boolean;
        updateFromNetwork(maxStress: number, currentStress: number, networkSize: number): void;
        getFlickerScore(): number;
        onLoad(): void;
        calculateAddedStressCapacity(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        hasSource(): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static convertToAngular(speed: number): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        isOverStressed(): boolean;
        asComponentProvider(): Internal.ComponentProvider;
        warnOfMovement(): void;
        getSpeed(): number;
        attachKinetics(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static convertToLinear(speed: number): number;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        static convertToDirection(axisSpeed: number, d: Internal.Direction_): number;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setNetwork(networkIn: number): void;
        onSpeedChanged(previousSpeed: number): void;
        addToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getRenderBoundingBox(): Internal.AABB;
        getOrCreateNetwork(): Internal.KineticNetwork;
        isSource(): boolean;
        detachKinetics(): void;
        isSpeedRequirementFulfilled(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setSource(source: BlockPos_): void;
        setSpeed(speed: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        needsSpeedUpdate(): boolean;
        getTheoreticalSpeed(): number;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        propagateRotationTo(target: Internal.KineticBlockEntity_, stateFrom: Internal.BlockState_, stateTo: Internal.BlockState_, diff: BlockPos_, connectedViaAxes: boolean, connectedViaCogs: boolean): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        hasNetwork(): boolean;
        getInfiniteBoundingBox(): Internal.AABB;
        tickAudio(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        removeSource(): void;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        addPropagationLocations(block: Internal.IRotate_, state: Internal.BlockState_, neighbours: Internal.List_<BlockPos>): Internal.List<BlockPos>;
        getRotationAngleOffset(axis: Internal.Direction$Axis_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get generatedSpeed(): number
        get flickerScore(): number
        get overStressed(): boolean
        get speed(): number
        set network(networkIn: number)
        get renderBoundingBox(): Internal.AABB
        get orCreateNetwork(): Internal.KineticNetwork
        get source(): boolean
        get speedRequirementFulfilled(): boolean
        set source(source: BlockPos_)
        set speed(speed: number)
        get theoreticalSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        networkDirty: boolean;
        preventSpeedUpdate: number;
        source: BlockPos;
        updateSpeed: boolean;
        sequenceContext: Internal.SequencedGearshiftBlockEntity$SequenceContext;
        network: number;
    }
    type KineticBlockEntity_ = KineticBlockEntity;
    class Giant extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.Giant>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Giant_ = Giant;
    interface IGenericCrossingTrackBE {
        getModel(data: net.createmod.catnip.data.Pair_<Internal.TrackMaterial, Internal.TrackShape>): Internal.BakedModel;
        getModel(material: Internal.TrackMaterial_, shape: Internal.TrackShape_): Internal.BakedModel;
        getQuads(data: net.createmod.catnip.data.Pair_<Internal.TrackMaterial, Internal.TrackShape>, side: Internal.Direction_, rand: Internal.RandomSource_): Internal.List<Internal.BakedQuad>;
        getQuads(material: Internal.TrackMaterial_, shape: Internal.TrackShape_, side: Internal.Direction_, rand: Internal.RandomSource_): Internal.List<Internal.BakedQuad>;
        abstract railways$getSecondCrossingPiece(): net.createmod.catnip.data.Pair<Internal.TrackMaterial, Internal.TrackShape>;
        abstract railways$getFirstCrossingPiece(): net.createmod.catnip.data.Pair<Internal.TrackMaterial, Internal.TrackShape>;
    }
    type IGenericCrossingTrackBE_ = IGenericCrossingTrackBE;
    interface ConfigFormat <C extends Internal.Config> {
        abstract createConfig(arg0: Internal.Supplier_<Internal.Map<string, any>>): C;
        abstract supportsComments(): boolean;
        createConcurrentConfig(): C;
        initEmptyFile(arg0: Internal.File_): void;
        initEmptyFile(arg0: Internal.Path_): void;
        abstract createWriter(): com.electronwill.nightconfig.core.io.ConfigWriter;
        createConfig(): C;
        initEmptyFile(arg0: Internal.Writer_): void;
        isInMemory(): boolean;
        abstract createParser(): com.electronwill.nightconfig.core.io.ConfigParser<C>;
        initEmptyFile(arg0: Internal.WriterSupplier_): void;
        supportsType(arg0: typeof any): boolean;
        get inMemory(): boolean
    }
    type ConfigFormat_<C extends Internal.Config> = ConfigFormat<C>;
    class FluidContainerList implements Internal.Iterable<Internal.FluidContainerList$Category> {
        constructor()
        constructor(categoryList: Internal.List_<Internal.FluidContainerList$Category>)
        getCategoryFromFilled(filledContainer: Internal.Item_): Internal.Optional<Internal.FluidContainerList$Category>;
        getPossibleFilled(): Internal.Collection<Internal.Item>;
        getCategoryFromEmpty(emptyContainer: Internal.Item_): Internal.Optional<Internal.FluidContainerList$Category>;
        getCategories(): Internal.Collection<Internal.FluidContainerList$Category>;
        getEmpty(filledContainer: Internal.Item_): Internal.Optional<Internal.Item>;
        getPossibleEmpty(): Internal.Collection<Internal.Item>;
        getFilled(emptyContainer: Internal.Item_): Internal.Optional<Internal.Item>;
        iterator(): Internal.Iterator<Internal.FluidContainerList$Category>;
        spliterator(): Internal.Spliterator<Internal.FluidContainerList$Category>;
        forEach(arg0: Internal.Consumer_<Internal.FluidContainerList$Category>): void;
        get possibleFilled(): Internal.Collection<Internal.Item>
        get categories(): Internal.Collection<Internal.FluidContainerList$Category>
        get possibleEmpty(): Internal.Collection<Internal.Item>
    }
    type FluidContainerList_ = FluidContainerList;
    interface AccessorSignBlockEntity {
        abstract bookshelf$markUpdated(): void;
        (): void;
    }
    type AccessorSignBlockEntity_ = AccessorSignBlockEntity;
    interface Transparency {
        abstract getTransparency(): number;
        get transparency(): number
        (): number;
        readonly TRANSLUCENT: 3;
        readonly OPAQUE: 1;
        readonly BITMASK: 2;
    }
    type Transparency_ = Transparency;
    class WidgetType extends Internal.Enum<Internal.WidgetType> {
        static mouseOver(mouseOver: boolean): Internal.WidgetType;
        static values(): Internal.WidgetType[];
        static valueOf(name: string): Internal.WidgetType;
        static readonly MOUSE_OVER: Internal.WidgetType;
        static readonly DISABLED: Internal.WidgetType;
        static readonly NORMAL: Internal.WidgetType;
    }
    type WidgetType_ = "normal" | "mouse_over" | "disabled" | WidgetType;
    interface BigSlot {
        abstract setBigSlot(arg0: boolean): Internal.Slot;
        abstract isBigSlot(): boolean;
        set bigSlot(arg0: boolean)
        get bigSlot(): boolean
    }
    type BigSlot_ = BigSlot;
    interface LivingEntityEvents$Visibility {
        abstract getEntityVisibilityMultiplier(arg0: Internal.LivingEntity_, arg1: Internal.Entity_, arg2: number): number;
        (arg0: Internal.LivingEntity, arg1: Internal.Entity, arg2: number): number;
    }
    type LivingEntityEvents$Visibility_ = LivingEntityEvents$Visibility;
    interface ObjLongConsumer <T> {
        abstract accept(arg0: T, arg1: number): void;
        (arg0: T, arg1: number): void;
    }
    type ObjLongConsumer_<T> = ObjLongConsumer<T>;
    interface AccessorRenderStateShard {
        abstract hex$name(): string;
        (): string;
    }
    type AccessorRenderStateShard_ = AccessorRenderStateShard;
    class CharStream {
        constructor(c: string[])
        peek(): string;
        nextIf(match: string): boolean;
        next(): string;
        peek(ahead: number): string;
        position: number;
        skipWhitespace: boolean;
        readonly chars: string[];
    }
    type CharStream_ = CharStream;
    class ItemStack implements Internal.ItemStackKJS, io.github.fabricators_of_create.porting_lib.tool.extensions.ItemStackExtensions, Internal.INBTSerializableCompound, Internal.ComponentProvider, Internal.ItemStackExtensions, Internal.EmiStackConvertible, Internal.FabricItemStack, Internal.SophisticatedItemStack, Internal.StorableItemStack, Internal.NbtCarrier {
        constructor($$0: Internal.Holder_<Internal.Item>)
        constructor($$0: Internal.Holder_<Internal.Item>, $$1: number)
        constructor($$0: Internal.ItemLike_)
        constructor($$0: Internal.ItemLike_, $$1: number)
        getTags(): Internal.Collection<ResourceLocation>;
        getDrinkingSound(): Internal.SoundEvent;
        self(): this;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getHoverName(): net.minecraft.network.chat.Component;
        unregisterFromInventory(stackList: Internal.LithiumStackList_): void;
        enchant(enchantment: Internal.Enchantment_, level: number): this;
        getBaseRepairCost(): number;
        isItemEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getFrame(): Internal.ItemFrame;
        getEnchantments(): Internal.Map<string, number>;
        onDestroyed($$0: Internal.ItemEntity_): void;
        static appendEnchantmentNames($$0: Internal.List_<net.minecraft.network.chat.Component>, $$1: Internal.ListTag_): void;
        enchant(enchantments: Internal.Map_<any, any>): this;
        handler$daj000$glitchcore$onFinishUsingItem(level: Internal.Level_, entity: Internal.LivingEntity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        static matches($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): boolean;
        hasAdventureModeBreakTagForBlock($$0: Internal.Registry_<Internal.Block>, $$1: Internal.BlockInWorld_): boolean;
        getPopTime(): number;
        getRarity(): Internal.Rarity;
        getDescriptionId(): string;
        hurtEnemy($$0: Internal.LivingEntity_, $$1: Internal.Player_): void;
        unregisterFromInventory(myInventoryList: Internal.LithiumStackList_, index: number): void;
        finishUsingItem($$0: Internal.Level_, $$1: Internal.LivingEntity_): this;
        registerToInventory(itemStacks: Internal.LithiumStackList_, mySlot: number): void;
        asComponentProvider(): Internal.ComponentProvider;
        getTypeData(): Internal.CompoundTag;
        addAttributeModifier($$0: Internal.Attribute_, $$1: Internal.AttributeModifier_, $$2: Internal.EquipmentSlot_): void;
        handler$daj000$glitchcore$onUse(level: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        is($$0: Internal.Predicate_<Internal.Holder<Internal.Item>>): boolean;
        hasAdventureModePlaceTagForBlock($$0: Internal.Registry_<Internal.Block>, $$1: Internal.BlockInWorld_): boolean;
        removeTag(): void;
        getItem(): Internal.Item;
        inventoryTick($$0: Internal.Level_, $$1: Internal.Entity_, $$2: number, $$3: boolean): void;
        is($$0: Internal.TagKey_<Internal.Item>): boolean;
        getOrCreateTagElement($$0: string): Internal.CompoundTag;
        hideTooltipPart($$0: Internal.ItemStack$TooltipPart_): void;
        getAttributeModifiers($$0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        "redirect$cep000$fabric-item-api-v1$hookGetAttributeModifiers"(item: Internal.Item_, slot: Internal.EquipmentSlot_): Internal.Multimap<any, any>;
        getMaxDamage(): number;
        getHarvestSpeed(): number;
        grow($$0: number): void;
        asIngredient(): Internal.Ingredient;
        getDisplayName(): net.minecraft.network.chat.Component;
        getCount(): number;
        "redirect$cep000$fabric-item-api-v1$hookIsSuitableFor"(item: Internal.Item_, state: Internal.BlockState_): boolean;
        onItemUseFirst(context: Internal.UseOnContext_): Internal.InteractionResult;
        hasCustomHoverName(): boolean;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        onArmorTick(level: Internal.Level_, player: Internal.Player_): void;
        "delete"(key: Internal.NbtKey_<any>): void;
        toJson(): Internal.JsonObject;
        useOn($$0: Internal.UseOnContext_): Internal.InteractionResult;
        isBarVisible(): boolean;
        static isSameItem($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): boolean;
        removeTagKey($$0: string): void;
        handler$daj000$glitchcore$onFinishUsingItemBegin(level: Internal.Level_, entity: Internal.LivingEntity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        onCraftedBy($$0: Internal.Level_, $$1: Internal.Player_, $$2: number): void;
        hasEnchantment(enchantment: Internal.Enchantment_, level: number): boolean;
        isEdible(): boolean;
        isFramed(): boolean;
        canPerformAction(toolAction: Internal.ToolAction_): boolean;
        use($$0: Internal.Level_, $$1: Internal.Player_, $$2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        enchantStack($$0: Internal.Enchantment_, $$1: number): void;
        copyIfPresent<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        handler$zcf000$porting_lib_base$port_lib$itemDamage(cir: Internal.CallbackInfoReturnable_<any>): void;
        getId(): Special.Item&`${string}:${string}`;
        get(key: Internal.NbtKey_<any>): any;
        setCount($$0: number): void;
        is($$0: Internal.Item_): boolean;
        setDamageValue($$0: number): void;
        equalsIgnoringCount(stack: Internal.ItemStack_): boolean;
        getOrCreateTag(): Internal.CompoundTag;
        copyWithCount($$0: number): this;
        getTagElement($$0: string): Internal.CompoundTag;
        onBlockStartBreak(pos: BlockPos_, player: Internal.Player_): boolean;
        modifyReturnValue$zcf000$porting_lib_base$port_lib$itemFlags(val: number): number;
        withCount(c: number): this;
        toNBT(): Internal.Tag;
        setHoverName($$0: net.minecraft.network.chat.Component_): this;
        getTags(): Internal.Stream<Internal.TagKey<Internal.Item>>;
        getBarWidth(): number;
        hasFoil(): boolean;
        setEntityRepresentation($$0: Internal.Entity_): void;
        getItemHolder(): Internal.Holder<Internal.Item>;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        split($$0: number): this;
        localvar$ehe000$lithium$updateInventory(count: number): number;
        setPopTime($$0: number): void;
        strongNBT(): Internal.Ingredient;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        isBlock(): boolean;
        getTooltipImage(): Internal.Optional<Internal.TooltipComponent>;
        getHarvestSpeed(block: Internal.BlockContainerJS_): number;
        shrink($$0: number): void;
        copyAndClear(): this;
        weakNBT(): Internal.Ingredient;
        withName(displayName: net.minecraft.network.chat.Component_): this;
        wrapOperation$dae001$geckolib$removeGeckolibIdOnCopy(instance: Internal.ItemStack_, count: number, original: Internal.Operation_<any>): this;
        is($$0: Internal.Holder_<Internal.Item>): boolean;
        overrideOtherStackedOnMe($$0: Internal.ItemStack_, $$1: Internal.Slot_, $$2: Internal.ClickAction_, $$3: Internal.Player_, $$4: Internal.SlotAccess_): boolean;
        withLore(text: net.minecraft.network.chat.Component_[]): this;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        isDamageableItem(): boolean;
        getTooltipLines($$0: Internal.Player_, $$1: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        isEnchantable(): boolean;
        getMaxStackSize(): number;
        specialEquals(o: any, shallow: boolean): boolean;
        handler$zcf000$porting_lib_base$port_lib$itemMaxDamage(cir: Internal.CallbackInfoReturnable_<any>): void;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        hasTag(tag: ResourceLocation_): boolean;
        getNbtString(): string;
        getDestroySpeed($$0: Internal.BlockState_): number;
        hurtAndBreak<T extends Internal.LivingEntity>($$0: number, $$1: T, $$2: Internal.Consumer_<T>): void;
        copy(): this;
        hasNBT(): boolean;
        isStackable(): boolean;
        isCorrectToolForDrops($$0: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        has(key: Internal.NbtKey_<any>): boolean;
        getComponentContainer(): Internal.ComponentContainer;
        getRecipeRemainder(): this;
        static of($$0: Internal.CompoundTag_): Internal.ItemStack;
        overrideStackedOnOther($$0: Internal.Slot_, $$1: Internal.ClickAction_, $$2: Internal.Player_): boolean;
        getEatingSound(): Internal.SoundEvent;
        getOr<T>(key: Internal.NbtKey_<T>, defaultValue: T): T;
        getEntityRepresentation(): Internal.Entity;
        static isSameItemSameTags($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): boolean;
        isEmpty(): boolean;
        put(key: Internal.NbtKey_<any>, value: any): void;
        mutate<T>(key: Internal.NbtKey_<T>, mutator: Internal.Function_<T, T>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        resetHoverName(): void;
        setNbt($$0: Internal.CompoundTag_): void;
        setRepairCost($$0: number): void;
        handler$zcf000$porting_lib_base$port_lib$itemSetDamage(damage: number, ci: Internal.CallbackInfo_): void;
        withChance(chance: number): OutputItem;
        onUseTick($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: number): void;
        getUseDuration(): number;
        serializeNBT(): Internal.Tag;
        hurt($$0: number, $$1: Internal.RandomSource_, $$2: Internal.ServerPlayer_): boolean;
        areItemsEqual(other: Internal.ItemStack_): boolean;
        getIdLocation(): ResourceLocation;
        isDamaged(): boolean;
        getMod(): string;
        mineBlock($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: Internal.Player_): void;
        getDamageValue(): number;
        getEnchantmentTags(): Internal.ListTag;
        getUseAnimation(): Internal.UseAnim;
        handler$zcf000$porting_lib_base$port_lib$onGetMaxCount(cir: Internal.CallbackInfoReturnable_<any>): void;
        deserializeNBT(arg0: Internal.Tag_): void;
        handler$ddg000$hexical$addAutograph(player: Internal.Player_, context: Internal.TooltipFlag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        toItemString(): string;
        withNBT(nbt: Internal.CompoundTag_): this;
        copy<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        interactLivingEntity($$0: Internal.Player_, $$1: Internal.LivingEntity_, $$2: Internal.InteractionHand_): Internal.InteractionResult;
        useOnRelease(): boolean;
        addTagElement($$0: string, $$1: Internal.Tag_): void;
        isNBTEqual(other: Internal.ItemStack_): boolean;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        putIfNotNull<T>(key: Internal.NbtKey_<T>, value: T): void;
        onDroppedByPlayer(player: Internal.Player_): boolean;
        emi(amount: number): Internal.EmiStack;
        /**
         * @deprecated
        */
        ignoreNBT(): Internal.Ingredient;
        releaseUsing($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: number): void;
        getBarColor(): number;
        isEnchanted(): boolean;
        get tags(): Internal.Collection<ResourceLocation>
        get drinkingSound(): Internal.SoundEvent
        get hoverName(): net.minecraft.network.chat.Component
        get baseRepairCost(): number
        get frame(): Internal.ItemFrame
        get enchantments(): Internal.Map<string, number>
        get popTime(): number
        get rarity(): Internal.Rarity
        get descriptionId(): string
        get typeData(): Internal.CompoundTag
        get item(): Internal.Item
        get maxDamage(): number
        get harvestSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        get count(): number
        get barVisible(): boolean
        get edible(): boolean
        get framed(): boolean
        get id(): Special.Item&`${string}:${string}`
        set count($$0: number)
        set damageValue($$0: number)
        get orCreateTag(): Internal.CompoundTag
        set hoverName($$0: net.minecraft.network.chat.Component_)
        get tags(): Internal.Stream<Internal.TagKey<Internal.Item>>
        get barWidth(): number
        set entityRepresentation($$0: Internal.Entity_)
        get itemHolder(): Internal.Holder<Internal.Item>
        set popTime($$0: number)
        get block(): boolean
        get tooltipImage(): Internal.Optional<Internal.TooltipComponent>
        get nbt(): Internal.CompoundTag
        get damageableItem(): boolean
        get enchantable(): boolean
        get maxStackSize(): number
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get nbtString(): string
        get stackable(): boolean
        get componentContainer(): Internal.ComponentContainer
        get recipeRemainder(): Internal.ItemStack
        get eatingSound(): Internal.SoundEvent
        get entityRepresentation(): Internal.Entity
        get empty(): boolean
        set nbt($$0: Internal.CompoundTag_)
        set repairCost($$0: number)
        get useDuration(): number
        get idLocation(): ResourceLocation
        get damaged(): boolean
        get mod(): string
        get damageValue(): number
        get enchantmentTags(): Internal.ListTag
        get useAnimation(): Internal.UseAnim
        get barColor(): number
        get enchanted(): boolean
        static readonly TAG_DISPLAY_NAME: "Name";
        static readonly TAG_LORE: "Lore";
        static readonly TAG_ENCH: "Enchantments";
        static readonly ATTRIBUTE_MODIFIER_FORMAT: Internal.DecimalFormat;
        static readonly TAG_DAMAGE: "Damage";
        static readonly CODEC: Internal.Codec<Internal.ItemStack>;
        tag: Internal.CompoundTag;
        static readonly TAG_DISPLAY: "display";
        static readonly TAG_COLOR: "color";
        static readonly EMPTY: Internal.ItemStack;
    }
    type ItemStack_ = {count?: number, nbt?: any_, maxRolls?: number, item: any_, minRolls?: number, chance?: number} | {count?: number, nbt?: any_, item: any_} | RegExp | Internal.Item_ | ItemStack | any_;
    interface TypeAdapterFactory {
        abstract create<T>(arg0: Internal.Gson_, arg1: com.google.gson.reflect.TypeToken_<T>): Internal.TypeAdapter<T>;
        (arg0: Internal.Gson, arg1: com.google.gson.reflect.TypeToken<T>): Internal.TypeAdapter_<T>;
    }
    type TypeAdapterFactory_ = TypeAdapterFactory;
    class InfinityUpgradeItem$Wrapper extends Internal.UpgradeWrapperBase<Internal.InfinityUpgradeItem$Wrapper, Internal.InfinityUpgradeItem> {
        hideSettingsTab(): boolean;
        getPermissionLevel(): number;
        get permissionLevel(): number
    }
    type InfinityUpgradeItem$Wrapper_ = InfinityUpgradeItem$Wrapper;
    class VerticalAnchor$AboveBottom extends Internal.Record implements Internal.VerticalAnchor {
        constructor($$0: number)
        static aboveBottom($$0: number): Internal.VerticalAnchor;
        static absolute($$0: number): Internal.VerticalAnchor;
        static belowTop($$0: number): Internal.VerticalAnchor;
        static bottom(): Internal.VerticalAnchor;
        static top(): Internal.VerticalAnchor;
        resolveY($$0: Internal.WorldGenerationContext_): number;
        offset(): number;
        static readonly CODEC: Internal.Codec<Internal.VerticalAnchor$AboveBottom>;
    }
    type VerticalAnchor$AboveBottom_ = VerticalAnchor$AboveBottom;
    class EndCityStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        static readonly CODEC: Internal.Codec<Internal.EndCityStructure>;
    }
    type EndCityStructure_ = EndCityStructure;
    class CombinedStorage <T, S extends Internal.Storage<T>> implements Internal.Storage<T> {
        constructor(parts: Internal.List_<S>)
        insert(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        iterator(): Internal.Iterator<Internal.StorageView<T>>;
        supportsInsertion(): boolean;
        static asClass<T>(): Internal.Storage<T>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<T>>;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<T>>;
        extract(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsExtraction(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: T): Internal.StorageView<T>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        get version(): number
        parts: Internal.List<S>;
    }
    type CombinedStorage_<T, S extends Internal.Storage<T>> = CombinedStorage<T, S>;
    class BoilerDisplaySource extends Internal.DisplaySource {
        constructor()
        static readonly notEnoughSpaceSingle: [Internal.MutableComponent];
        static readonly notEnoughSpaceFlap: [[Internal.MutableComponent], [Internal.MutableComponent]];
        static readonly notEnoughSpaceDouble: [Internal.MutableComponent, Internal.MutableComponent];
    }
    type BoilerDisplaySource_ = BoilerDisplaySource;
    abstract class SingleItemRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor($$0: Internal.RecipeType_<any>, $$1: Internal.RecipeSerializer_<any>, $$2: ResourceLocation_, $$3: string, $$4: Internal.Ingredient_, $$5: Internal.ItemStack_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble($$0: net.minecraft.world.Container_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        abstract matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type SingleItemRecipe_ = SingleItemRecipe;
    class ExtractorRecipeJS extends Internal.ExcavatingRecipeJS<Internal.ExtractorRecipeJS> {
        constructor()
        getMod(): string;
        get mod(): string
        static readonly TICKS: Internal.RecipeKey<number>;
        static readonly VEIN_NAME: Internal.RecipeKey<string>;
        static readonly SCHEMA: Internal.RecipeSchema;
        static readonly RESULT: Internal.RecipeKey<Internal.OutputFluid>;
    }
    type ExtractorRecipeJS_ = ExtractorRecipeJS;
    class ModifierSetWorktableRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.ModifierSetWorktableRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ModifierSetWorktableRecipe;
    }
    type ModifierSetWorktableRecipe$Serializer_ = ModifierSetWorktableRecipe$Serializer;
    abstract class AbstractCraftingUnitBlock <T> extends Internal.AEBaseEntityBlock<T> {
        constructor(props: Internal.BlockBehaviour$Properties_, type: Internal.ICraftingUnitType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        readonly type: Internal.ICraftingUnitType;
        static readonly FORMED: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type AbstractCraftingUnitBlock_<T> = AbstractCraftingUnitBlock<T>;
    abstract class PointFree <T> {
        constructor()
        abstract "eval"(): Internal.Function<Internal.DynamicOps<any>, T>;
        static indent(arg0: number): string;
        abstract type(): com.mojang.datafixers.types.Type<T>;
        evalCached(): Internal.Function<Internal.DynamicOps<any>, T>;
        abstract toString(arg0: number): string;
    }
    type PointFree_<T> = PointFree<T>;
    interface FileNameMap {
        abstract getContentTypeFor(arg0: string): string;
        (arg0: string): string;
    }
    type FileNameMap_ = FileNameMap;
    class ItemArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.Iterable<Internal.HexPattern>;
        arithName(): string;
        static readonly INSTANCE: Internal.ItemArithmetic;
        static readonly EXTRACT_ITEM: Internal.HexPattern;
    }
    type ItemArithmetic_ = ItemArithmetic;
    class StructureTemplatePool implements Internal.AccessorStructureTemplatePool {
        constructor($$0: Internal.Holder_<Internal.StructureTemplatePool>, $$1: Internal.List_<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>)
        constructor($$0: Internal.Holder_<Internal.StructureTemplatePool>, $$1: Internal.List_<com.mojang.datafixers.util.Pair<Internal.Function<Internal.StructureTemplatePool$Projection, Internal.StructurePoolElement>, number>>, $$2: Internal.StructureTemplatePool$Projection_)
        bookshelf$setRawTemplates(arg0: Internal.List_<any>): void;
        getRandomTemplate($$0: Internal.RandomSource_): Internal.StructurePoolElement;
        bookshelf$setTemplates(arg0: Internal.ObjectArrayList_<any>): void;
        size(): number;
        getFallback(): Internal.Holder<Internal.StructureTemplatePool>;
        getShuffledTemplates($$0: Internal.RandomSource_): Internal.List<Internal.StructurePoolElement>;
        bookshelf$getRawTemplates(): Internal.List<any>;
        getMaxSize($$0: Internal.StructureTemplateManager_): number;
        bookshelf$getTemplates(): Internal.ObjectArrayList<any>;
        get fallback(): Internal.Holder<Internal.StructureTemplatePool>
        static readonly DIRECT_CODEC: Internal.Codec<Internal.StructureTemplatePool>;
        rawTemplates: Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>;
        templates: Internal.ObjectArrayList<Internal.StructurePoolElement>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.StructureTemplatePool>>;
    }
    type StructureTemplatePool_ = StructureTemplatePool | Special.TemplatePool;
    class RollingRecipe extends Internal.ProcessingRecipe<Internal.RecipeWrapper> implements Internal.IAssemblyRecipe {
        getDescriptionForAssembly(): net.minecraft.network.chat.Component;
        supportsAssembly(): boolean;
        getGroup(): string;
        getSchema(): Internal.RecipeSchema;
        matches(inv: Internal.RecipeWrapper_, worldIn: Internal.Level_): boolean;
        getJEISubCategory(): Internal.SequencedAssemblySubCategoryType;
        addRequiredMachines(set: Internal.Set_<Internal.ItemLike>): void;
        static register(): void;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        getIngredient(): Internal.Ingredient;
        getResultItem(): Internal.ItemStack;
        getMod(): string;
        assemble(inv: Internal.RecipeWrapper_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        addAssemblyFluidIngredients(list: Internal.List_<Internal.FluidIngredient>): void;
        getRemainingItems($$0: Internal.RecipeWrapper_): Internal.NonNullList<Internal.ItemStack>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        addAssemblyIngredients(list: Internal.List_<Internal.Ingredient>): void;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get descriptionForAssembly(): net.minecraft.network.chat.Component
        get group(): string
        get schema(): Internal.RecipeSchema
        get JEISubCategory(): Internal.SequencedAssemblySubCategoryType
        get ingredient(): Internal.Ingredient
        get resultItem(): Internal.ItemStack
        get mod(): string
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type RollingRecipe_ = RollingRecipe;
    class TrackBufferBlockItem extends Internal.TrackTargetingBlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_, type: Internal.EdgePointType_<any>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static ofType<T extends Internal.Block>(type: Internal.EdgePointType_<any>): Internal.NonNullBiFunction<T, Internal.Item$Properties, Internal.TrackTargetingBlockItem>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TrackBufferBlockItem_ = TrackBufferBlockItem;
    interface AccessibleText {
        abstract getBeforeIndex(arg0: number, arg1: number): string;
        abstract getSelectionStart(): number;
        abstract getSelectedText(): string;
        abstract getAtIndex(arg0: number, arg1: number): string;
        abstract getAfterIndex(arg0: number, arg1: number): string;
        abstract getSelectionEnd(): number;
        abstract getCharacterBounds(arg0: number): Internal.Rectangle;
        abstract getCaretPosition(): number;
        abstract getIndexAtPoint(arg0: Internal.Point_): number;
        abstract getCharCount(): number;
        abstract getCharacterAttribute(arg0: number): Internal.AttributeSet;
        get selectionStart(): number
        get selectedText(): string
        get selectionEnd(): number
        get caretPosition(): number
        get charCount(): number
        readonly CHARACTER: 1;
        readonly WORD: 2;
        readonly SENTENCE: 3;
    }
    type AccessibleText_ = AccessibleText;
    interface TransformableBlock {
        abstract transform(arg0: Internal.BlockState_, arg1: Internal.StructureTransform_): Internal.BlockState;
        (arg0: Internal.BlockState, arg1: Internal.StructureTransform): Internal.BlockState_;
    }
    type TransformableBlock_ = TransformableBlock;
    class TieredEnergyValues {
        constructor(starter: number, basic: number, hardened: number, blazing: number, niotic: number, spirited: number, nitro: number)
        copy(factor: number): this;
        get(tier: owmii.powah.block.Tier_): number;
        starter: number;
        nitro: number;
        basic: number;
        spirited: number;
        hardened: number;
        blazing: number;
        niotic: number;
    }
    type TieredEnergyValues_ = TieredEnergyValues;
    class BlockDreadTorchWall extends Internal.WallTorchBlock implements Internal.IDreadBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockDreadTorchWall_ = BlockDreadTorchWall;
    class EntropyRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(id: ResourceLocation_, mode: Internal.EntropyMode_, inputBlock: Internal.Block_, inputBlockMatchers: Internal.List_<any>, inputFluid: Internal.Fluid_, inputFluidMatchers: Internal.List_<any>, outputBlock: Internal.Block_, outputBlockStateAppliers: Internal.List_<any>, outputBlockKeep: boolean, outputFluid: Internal.Fluid_, outputFluidStateAppliers: Internal.List_<any>, outputFluidKeep: boolean, drops: Internal.List_<Internal.ItemStack>)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(inv: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getOutputBlockState(originalBlockState: Internal.BlockState_): Internal.BlockState;
        getOutputBlock(): Internal.Block;
        getMode(): Internal.EntropyMode;
        getDrops(): Internal.List<Internal.ItemStack>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(inv: net.minecraft.world.Container_, level: Internal.Level_): boolean;
        getOutputBlockKeep(): boolean;
        getMod(): string;
        getOutputFluid(): Internal.Fluid;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(width: number, height: number): boolean;
        getInputFluid(): Internal.Fluid;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getInputBlock(): Internal.Block;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        matches(mode: Internal.EntropyMode_, blockState: Internal.BlockState_, fluidState: Internal.FluidState_): boolean;
        isIncomplete(): boolean;
        getOutputFluidState(originalFluidState: Internal.FluidState_): Internal.FluidState;
        getOutputFluidKeep(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get outputBlock(): Internal.Block
        get mode(): Internal.EntropyMode
        get drops(): Internal.List<Internal.ItemStack>
        get outputBlockKeep(): boolean
        get mod(): string
        get outputFluid(): Internal.Fluid
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get inputFluid(): Internal.Fluid
        get type(): ResourceLocation
        get inputBlock(): Internal.Block
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get outputFluidKeep(): boolean
        static readonly TYPE: Internal.RecipeType$1;
        static readonly TYPE_ID: ResourceLocation;
    }
    type EntropyRecipe_ = EntropyRecipe;
    interface ScriptTypePredicate extends Internal.Predicate<Internal.ScriptType> {
        getValidTypes(): Internal.List<Internal.ScriptType>;
        test(arg0: any): boolean;
        negate(): Internal.Predicate<Internal.ScriptType>;
        and(arg0: Internal.Predicate_<Internal.ScriptType>): Internal.Predicate<Internal.ScriptType>;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        abstract test(arg0: Internal.ScriptType_): boolean;
        or(arg0: Internal.Predicate_<Internal.ScriptType>): Internal.Predicate<Internal.ScriptType>;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        get validTypes(): Internal.List<Internal.ScriptType>
        (arg0: Internal.ScriptType): boolean;
        readonly COMMON: Internal.ScriptTypePredicate;
        readonly STARTUP_OR_CLIENT: Internal.ScriptTypePredicate;
        readonly STARTUP_OR_SERVER: Internal.ScriptTypePredicate;
        readonly ALL: Internal.ScriptTypePredicate;
    }
    type ScriptTypePredicate_ = ScriptTypePredicate;
    class AEDecorativeBlock extends Internal.AEBaseBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type AEDecorativeBlock_ = AEDecorativeBlock;
    class RealmsClient {
        constructor($$0: string, $$1: string, $$2: Internal.Minecraft_)
        getLiveStats(): Internal.RealmsServerPlayerLists;
        requestDownloadInfo($$0: number, $$1: number): Internal.WorldDownload;
        restoreWorld($$0: number, $$1: string): void;
        backupsFor($$0: number): Internal.BackupList;
        switchSlot($$0: number, $$1: number): boolean;
        rejectInvitation($$0: string): void;
        initializeWorld($$0: number, $$1: string, $$2: string): void;
        close($$0: number): boolean;
        deop($$0: number, $$1: string): Internal.Ops;
        static switchToProd(): void;
        update($$0: number, $$1: string, $$2: string): void;
        notificationsSeen($$0: Internal.List_<Internal.UUID>): void;
        deleteWorld($$0: number): void;
        open($$0: number): boolean;
        getOwnWorld($$0: number): Internal.RealmsServer;
        stageAvailable(): boolean;
        trialAvailable(): boolean;
        agreeToTos(): void;
        mcoEnabled(): boolean;
        sendPingResults($$0: Internal.PingResult_): void;
        pendingInvites(): Internal.PendingInvitesList;
        subscriptionFor($$0: number): Internal.Subscription;
        getNews(): Internal.RealmsNews;
        clientCompatible(): Internal.RealmsClient$CompatibleVersionResponse;
        notificationsDismiss($$0: Internal.List_<Internal.UUID>): void;
        getNotifications(): Internal.List<Internal.RealmsNotification>;
        listWorlds(): Internal.RealmsServerList;
        uninviteMyselfFrom($$0: number): void;
        updateSlot($$0: number, $$1: number, $$2: Internal.RealmsWorldOptions_): void;
        op($$0: number, $$1: string): Internal.Ops;
        static switchToLocal(): void;
        static create($$0: Internal.Minecraft_): Internal.RealmsClient;
        invite($$0: number, $$1: string): Internal.RealmsServer;
        putIntoMinigameMode($$0: number, $$1: string): boolean;
        getActivity($$0: number): Internal.ServerActivityList;
        join($$0: number): Internal.RealmsServerAddress;
        acceptInvitation($$0: string): void;
        static create(): Internal.RealmsClient;
        resetWorldWithSeed($$0: number, $$1: Internal.WorldGenerationInfo_): boolean;
        requestUploadInfo($$0: number, $$1: string): Internal.UploadInfo;
        resetWorldWithTemplate($$0: number, $$1: string): boolean;
        static switchToStage(): void;
        pendingInvitesCount(): number;
        uninvite($$0: number, $$1: string): void;
        fetchWorldTemplates($$0: number, $$1: number, $$2: Internal.RealmsServer$WorldType_): Internal.WorldTemplatePaginatedList;
        get liveStats(): Internal.RealmsServerPlayerLists
        get news(): Internal.RealmsNews
        get notifications(): Internal.List<Internal.RealmsNotification>
        static currentEnvironment: Internal.RealmsClient$Environment;
    }
    type RealmsClient_ = RealmsClient;
    class CustomMapDecoration {
        constructor(type: Internal.MapDecorationType_<any, any>, buffer: Internal.FriendlyByteBuf_)
        constructor(type: Internal.MapDecorationType_<any, any>, x: number, y: number, rot: number, displayName: net.minecraft.network.chat.Component_)
        getDisplayName(): net.minecraft.network.chat.Component;
        getX(): number;
        setDisplayName(displayName: net.minecraft.network.chat.Component_): void;
        getRot(): number;
        getType(): Internal.MapDecorationType<any, any>;
        setRot(rot: number): void;
        setX(x: number): void;
        setY(y: number): void;
        saveToBuffer(buffer: Internal.FriendlyByteBuf_): void;
        getY(): number;
        get displayName(): net.minecraft.network.chat.Component
        get x(): number
        set displayName(displayName: net.minecraft.network.chat.Component_)
        get rot(): number
        get type(): Internal.MapDecorationType<any, any>
        set rot(rot: number)
        set x(x: number)
        set y(y: number)
        get y(): number
    }
    type CustomMapDecoration_ = CustomMapDecoration;
    interface LevelTickAccess <T> extends Internal.TickAccess<T> {
        abstract count(): number;
        abstract schedule(arg0: Internal.ScheduledTick_<T>): void;
        abstract willTickThisTick(arg0: BlockPos_, arg1: T): boolean;
        abstract hasScheduledTick(arg0: BlockPos_, arg1: T): boolean;
    }
    type LevelTickAccess_<T> = LevelTickAccess<T>;
    class RenderStateShard$LightmapStateShard extends Internal.RenderStateShard$BooleanStateShard {
        constructor($$0: boolean)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$LightmapStateShard_ = RenderStateShard$LightmapStateShard;
    class PointerBuffer extends Internal.CustomBuffer<Internal.PointerBuffer> implements Internal.Comparable<Internal.PointerBuffer> {
        put(arg0: number, arg1: number): this;
        put(arg0: Internal.DoubleBuffer_): this;
        put(arg0: Internal.LongBuffer_): this;
        getPointerBuffer(arg0: number): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        getPointerBuffer(arg0: number, arg1: number): this;
        put(arg0: number, arg1: Internal.DoubleBuffer_): this;
        getByteBuffer(arg0: number, arg1: number): Internal.ByteBuffer;
        compareTo(arg0: any): number;
        getStringUTF8(): string;
        getShortBuffer(arg0: number, arg1: number): Internal.ShortBuffer;
        getShortBuffer(arg0: number): Internal.ShortBuffer;
        putAddressOf(arg0: number, arg1: Internal.CustomBuffer_<any>): this;
        static put(arg0: Internal.ByteBuffer_, arg1: number): void;
        static get(arg0: Internal.ByteBuffer_, arg1: number): number;
        put(arg0: number, arg1: Internal.FloatBuffer_): this;
        static get(arg0: Internal.ByteBuffer_): number;
        get(arg0: number[], arg1: number, arg2: number): this;
        put(arg0: number, arg1: Internal.LongBuffer_): this;
        getStringUTF16(): string;
        getStringASCII(arg0: number): string;
        compareTo(arg0: Internal.PointerBuffer_): number;
        put(arg0: Internal.FloatBuffer_): this;
        put(arg0: number[]): this;
        static allocateDirect(arg0: number): Internal.PointerBuffer;
        get(arg0: number): number;
        static create(arg0: number, arg1: number): Internal.PointerBuffer;
        put(arg0: number, arg1: Internal.ByteBuffer_): this;
        getStringUTF16(arg0: number): string;
        static create(arg0: Internal.ByteBuffer_): Internal.PointerBuffer;
        put(arg0: Internal.IntBuffer_): this;
        put(arg0: number, arg1: Internal.ShortBuffer_): this;
        get(arg0: number[]): this;
        put(arg0: number, arg1: Internal.Pointer_): this;
        put(arg0: Internal.ByteBuffer_): this;
        put(arg0: Internal.ShortBuffer_): this;
        put(arg0: Internal.Pointer_): this;
        put(arg0: number, arg1: Internal.IntBuffer_): this;
        getStringASCII(): string;
        get(): number;
        putAddressOf(arg0: Internal.CustomBuffer_<any>): this;
        getFloatBuffer(arg0: number): Internal.FloatBuffer;
        getStringUTF8(arg0: number): string;
        getIntBuffer(arg0: number): Internal.IntBuffer;
        put(arg0: number): this;
        static put(arg0: Internal.ByteBuffer_, arg1: number, arg2: number): void;
        getFloatBuffer(arg0: number, arg1: number): Internal.FloatBuffer;
        getDoubleBuffer(arg0: number): Internal.DoubleBuffer;
        getLongBuffer(arg0: number): Internal.LongBuffer;
        getDoubleBuffer(arg0: number, arg1: number): Internal.DoubleBuffer;
        getByteBuffer(arg0: number): Internal.ByteBuffer;
        getLongBuffer(arg0: number, arg1: number): Internal.LongBuffer;
        getIntBuffer(arg0: number, arg1: number): Internal.IntBuffer;
        get stringUTF8(): string
        get stringUTF16(): string
        get stringASCII(): string
    }
    type PointerBuffer_ = PointerBuffer;
    abstract class AbstractCriterionTriggerInstance implements Internal.CriterionTriggerInstance {
        constructor($$0: ResourceLocation_, $$1: any_)
        serializeToJson($$0: Internal.SerializationContext_): Internal.JsonObject;
        getCriterion(): ResourceLocation;
        get criterion(): ResourceLocation
    }
    type AbstractCriterionTriggerInstance_ = AbstractCriterionTriggerInstance;
    class GameEventListenerRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_)
        trackGameEvent($$0: Internal.GameEvent_, $$1: Vec3d_): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
        trackListener($$0: Internal.PositionSource_, $$1: number): void;
    }
    type GameEventListenerRenderer_ = GameEventListenerRenderer;
    interface SpruceElement extends Internal.GuiEventListener {
        charTyped($$0: string, $$1: number): boolean;
        abstract isFocused(): boolean;
        requiresCursor(): boolean;
        abstract setFocused(arg0: boolean): void;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        getTabOrderGroup(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        mouseClicked($$0: number, $$1: number, $$2: number): boolean;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        mouseMoved($$0: number, $$1: number): void;
        onNavigation(direction: Internal.NavigationDirection_, tab: boolean): boolean;
        getRectangle(): Internal.ScreenRectangle;
        isMouseOver($$0: number, $$1: number): boolean;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        get focused(): boolean
        set focused(arg0: boolean)
        get tabOrderGroup(): number
        get currentFocusPath(): Internal.ComponentPath
        get rectangle(): Internal.ScreenRectangle
    }
    type SpruceElement_ = SpruceElement;
    class DesertWellFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type DesertWellFeature_ = DesertWellFeature;
    class PistonMovingBlockEntity extends Internal.BlockEntity implements Internal.IExtendedPistonTile, Internal.IBlockHolder {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        constructor($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.Direction_, $$4: boolean, $$5: boolean)
        getMovementDirection(): Internal.Direction;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isSourcePiston(): boolean;
        getHeldBlock(): Internal.BlockState;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getMovedState(): Internal.BlockState;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getLastTicked(): number;
        handler$ffc000$moonlight$onFinishedShortPulse(ci: Internal.CallbackInfo_): void;
        tickMovedBlock(level: Internal.Level_, pos: BlockPos_): void;
        getProgress($$0: number): number;
        onLoad(): void;
        getZOff($$0: number): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        isExtending(): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        static tick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.PistonMovingBlockEntity_): void;
        invalidateCaps(): void;
        getXOff($$0: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        setHeldBlock(state: Internal.BlockState_): boolean;
        abstract getHeldBlock(arg0: number): Internal.BlockState;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getCollisionShape($$0: Internal.BlockGetter_, $$1: BlockPos_): Internal.VoxelShape;
        getYOff($$0: number): number;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        abstract setHeldBlock(arg0: Internal.BlockState_, arg1: number): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        finalTick(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDirection(): Internal.Direction;
        get movementDirection(): Internal.Direction
        get sourcePiston(): boolean
        get heldBlock(): Internal.BlockState
        get movedState(): Internal.BlockState
        get lastTicked(): number
        get extending(): boolean
        set heldBlock(state: Internal.BlockState_)
        get direction(): Internal.Direction
        static readonly TICK_MOVEMENT: 0.51;
    }
    type PistonMovingBlockEntity_ = PistonMovingBlockEntity;
    class BufferedReader extends Internal.Reader {
        constructor(arg0: Internal.Reader_, arg1: number)
        constructor(arg0: Internal.Reader_)
        readLine(): string;
        lines(): Internal.Stream<string>;
    }
    type BufferedReader_ = BufferedReader;
    class DyeIota$Companion$TYPE$1 extends Internal.IotaType<any> {
        deserialize(p0: Internal.Tag_, p1: Internal.ServerLevel_): Internal.Iota;
    }
    type DyeIota$Companion$TYPE$1_ = DyeIota$Companion$TYPE$1;
    class BookItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BookItem_ = BookItem;
    class SampleDrillBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveHoveringInformation, Internal.IDrill, Internal.IHaveGoggleInformation {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getRotation(): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        shouldRenderShaft(): boolean;
        setDrilling(drilling: boolean): void;
        getYOffset(): number;
        setProgress(progress: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getFacing(): Internal.Direction;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        shouldRenderRubble(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        setAirTankLevel(airTankLevel: number): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPrevRotation(): number;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getDrill(): Internal.ItemStack;
        clicked(player: Internal.Player_): void;
        addToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDrillOffset(): number;
        getBelow(): BlockPos;
        get rotation(): number
        set drilling(drilling: boolean)
        get YOffset(): number
        set progress(progress: number)
        get facing(): Internal.Direction
        set airTankLevel(airTankLevel: number)
        get prevRotation(): number
        get infiniteBoundingBox(): Internal.AABB
        get drill(): Internal.ItemStack
        get drillOffset(): number
        get below(): BlockPos
        static readonly DRILL_TIME: 200;
    }
    type SampleDrillBlockEntity_ = SampleDrillBlockEntity;
    class SimpleParticleType extends Internal.ParticleType<Internal.SimpleParticleType> implements Internal.ParticleOptions {
        constructor($$0: boolean)
        getType(): Internal.ParticleType<any>;
        writeToString(): string;
        writeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        getType(): this;
        codec(): Internal.Codec<Internal.SimpleParticleType>;
        get type(): Internal.ParticleType<any>
        get type(): Internal.SimpleParticleType
    }
    type SimpleParticleType_ = SimpleParticleType;
    class UnderwaterMagmaFeature extends Internal.Feature<Internal.UnderwaterMagmaConfiguration> {
        constructor($$0: Internal.Codec_<Internal.UnderwaterMagmaConfiguration>)
    }
    type UnderwaterMagmaFeature_ = UnderwaterMagmaFeature;
    interface ScreenMouseEvents$BeforeMouseRelease {
        abstract beforeMouseRelease(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenMouseEvents$BeforeMouseRelease_ = ScreenMouseEvents$BeforeMouseRelease;
    class ItemDyePigment extends Internal.Item implements Internal.PigmentItem {
        constructor(dyeColor: Internal.DyeColor_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getDyeColor(): Internal.DyeColor;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        provideColor(stack: Internal.ItemStack_, owner: Internal.UUID_): Internal.ColorProvider;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get dyeColor(): Internal.DyeColor
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDyePigment_ = ItemDyePigment;
    interface MenuBuilder$ForgeMenuFactory <T extends Internal.AbstractContainerMenu> {
        abstract create(arg0: Internal.MenuType_<T>, arg1: number, arg2: Internal.Inventory_, arg3: Internal.FriendlyByteBuf_): T;
        (arg0: Internal.MenuType<T>, arg1: number, arg2: Internal.Inventory, arg3: Internal.FriendlyByteBuf): T;
    }
    type MenuBuilder$ForgeMenuFactory_<T extends Internal.AbstractContainerMenu> = MenuBuilder$ForgeMenuFactory<T>;
    class DataGenerator$PackGenerator {
        addProvider<T extends Internal.DataProvider>($$0: Internal.DataProvider$Factory_<T>): T;
    }
    type DataGenerator$PackGenerator_ = DataGenerator$PackGenerator;
    class TeamPropertyValue <T> {
        constructor(property: Internal.TeamProperty_<T>, value: T)
        constructor(k: Internal.TeamProperty_<T>)
        setValue(value: T): void;
        getValue(): T;
        getProperty(): Internal.TeamProperty<T>;
        copy(): this;
        set value(value: T)
        get value(): T
        get property(): Internal.TeamProperty<T>
    }
    type TeamPropertyValue_<T> = TeamPropertyValue<T>;
    interface SwitchablePlayerEntity {
        abstract cca$isSwitchingCharacter(): boolean;
        abstract cca$markAsSwitchingCharacter(): void;
    }
    type SwitchablePlayerEntity_ = SwitchablePlayerEntity;
    interface NeutralMob {
        playerDied($$0: Internal.Player_): void;
        abstract getTarget(): Internal.LivingEntity;
        abstract getPersistentAngerTarget(): Internal.UUID;
        isAngry(): boolean;
        abstract setLastHurtByMob(arg0: Internal.LivingEntity_): void;
        forgetCurrentTargetAndRefreshUniversalAnger(): void;
        readPersistentAngerSaveData($$0: Internal.Level_, $$1: Internal.CompoundTag_): void;
        abstract startPersistentAngerTimer(): void;
        stopBeingAngry(): void;
        abstract canAttack(arg0: Internal.LivingEntity_): boolean;
        abstract setLastHurtByPlayer(arg0: Internal.Player_): void;
        abstract setTarget(arg0: Internal.LivingEntity_): void;
        abstract setPersistentAngerTarget(arg0: Internal.UUID_): void;
        addPersistentAngerSaveData($$0: Internal.CompoundTag_): void;
        abstract setRemainingPersistentAngerTime(arg0: number): void;
        updatePersistentAnger($$0: Internal.ServerLevel_, $$1: boolean): void;
        isAngryAtAllPlayers($$0: Internal.Level_): boolean;
        abstract getLastHurtByMob(): Internal.LivingEntity;
        isAngryAt($$0: Internal.LivingEntity_): boolean;
        abstract getRemainingPersistentAngerTime(): number;
        get target(): Internal.LivingEntity
        get persistentAngerTarget(): Internal.UUID
        get angry(): boolean
        set lastHurtByMob(arg0: Internal.LivingEntity_)
        set lastHurtByPlayer(arg0: Internal.Player_)
        set target(arg0: Internal.LivingEntity_)
        set persistentAngerTarget(arg0: Internal.UUID_)
        set remainingPersistentAngerTime(arg0: number)
        get lastHurtByMob(): Internal.LivingEntity
        get remainingPersistentAngerTime(): number
        readonly TAG_ANGER_TIME: "AngerTime";
        readonly TAG_ANGRY_AT: "AngryAt";
    }
    type NeutralMob_ = NeutralMob;
    class ItemAmbrosia extends Internal.ItemGenericFood {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemAmbrosia_ = ItemAmbrosia;
    class GuiMessage$Line extends Internal.Record implements Internal.HeadRenderable {
        constructor($$0: number, $$1: Internal.FormattedCharSequence_, $$2: Internal.GuiMessageTag_, $$3: boolean)
        content(): Internal.FormattedCharSequence;
        addedTime(): number;
        handler$bjj000$chat_heads$chatheads$setOwnerForFirstLine(callbackInfo: Internal.CallbackInfo_): void;
        chatheads$getHeadData(): Internal.HeadData;
        tag(): Internal.GuiMessageTag;
        endOfEntry(): boolean;
        abstract chatheads$setHeadData(arg0: Internal.HeadData_): void;
        chatheads$headData: Internal.HeadData;
    }
    type GuiMessage$Line_ = GuiMessage$Line;
    class AEItemKeys extends Internal.AEKeyType {
        readFromPacket(input: Internal.FriendlyByteBuf_): Internal.AEItemKey;
    }
    type AEItemKeys_ = AEItemKeys;
    class DragonLandingApproachPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        getPhase(): Internal.EnderDragonPhase<Internal.DragonLandingApproachPhase>;
        get phase(): Internal.EnderDragonPhase<Internal.DragonLandingApproachPhase>
    }
    type DragonLandingApproachPhase_ = DragonLandingApproachPhase;
}
declare namespace net.darkhax.bookshelf.mixin.accessors.entity {
    interface AccessorEntity {
        abstract bookshelf$createHoverEvent(): Internal.HoverEvent;
        (): Internal.HoverEvent_;
    }
    type AccessorEntity_ = AccessorEntity;
}
declare namespace net.createmod.ponder.mixin.client.accessor {
    interface GameRendererAccessor {
        abstract catnip$callGetFov(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        (arg0: Internal.Camera, arg1: number, arg2: boolean): number;
    }
    type GameRendererAccessor_ = GameRendererAccessor;
}
declare namespace dev.lambdaurora.lambdynlights.shadow.nightconfig.core {
    interface UnmodifiableConfig {
        getOrElse<T>(path: string, defaultValue: T): T;
        getLong(path: string): number;
        getEnum<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T): T;
        getInt(path: Internal.List_<string>): number;
        getByteOrElse(path: string, defaultValue: number): number;
        getShortOrElse(path: string, defaultValue: number): number;
        get<T>(path: Internal.List_<string>): T;
        abstract configFormat(): dev.lambdaurora.lambdynlights.shadow.nightconfig.core.ConfigFormat<any>;
        getCharOrElse(path: string, defaultValue: string): string;
        getEnum<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T, method: Internal.EnumGetMethod_): T;
        getEnumOrElse<T extends Internal.Enum<T>>(path: string, enumType: T, method: Internal.EnumGetMethod_, defaultValueSupplier: Internal.Supplier_<T>): T;
        contains(path: string): boolean;
        getShort(path: Internal.List_<string>): number;
        getShortOrElse(path: Internal.List_<string>, defaultValue: number): number;
        isNull(path: Internal.List_<string>): boolean;
        getIntOrElse(path: Internal.List_<string>, defaultValue: number): number;
        abstract getRaw<T>(arg0: Internal.List_<string>): T;
        getOrElse<T>(path: Internal.List_<string>, defaultValueSupplier: Internal.Supplier_<T>): T;
        abstract entrySet(): Internal.Set<dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig$Entry>;
        getOptionalLong(path: string): Internal.OptionalLong;
        getOptional<T>(path: Internal.List_<string>): Internal.Optional<T>;
        getEnum<T extends Internal.Enum<T>>(path: string, enumType: T): T;
        getOptional<T>(path: string): Internal.Optional<T>;
        getShort(path: string): number;
        getOrElse<T>(path: string, defaultValueSupplier: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(path: string, defaultValue: T, method: Internal.EnumGetMethod_): T;
        getChar(path: string): string;
        getOrElse<T>(path: Internal.List_<string>, defaultValue: T): T;
        getEnumOrElse<T extends Internal.Enum<T>>(path: Internal.List_<string>, defaultValue: T, method: Internal.EnumGetMethod_): T;
        getOptionalLong(path: Internal.List_<string>): Internal.OptionalLong;
        getChar(path: Internal.List_<string>): string;
        get<T>(path: string): T;
        abstract contains(arg0: Internal.List_<string>): boolean;
        getLong(path: Internal.List_<string>): number;
        apply<T>(path: Internal.List_<string>): T;
        getOptionalEnum<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T, method: Internal.EnumGetMethod_): Internal.Optional<T>;
        getLongOrElse(path: Internal.List_<string>, defaultValueSupplier: Internal.LongSupplier_): number;
        getInt(path: string): number;
        getLongOrElse(path: Internal.List_<string>, defaultValue: number): number;
        isEmpty(): boolean;
        getIntOrElse(path: Internal.List_<string>, defaultValueSupplier: Internal.IntSupplier_): number;
        getEnum<T extends Internal.Enum<T>>(path: string, enumType: T, method: Internal.EnumGetMethod_): T;
        getRaw<T>(path: string): T;
        getIntOrElse(path: string, defaultValueSupplier: Internal.IntSupplier_): number;
        isNull(path: string): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(path: Internal.List_<string>, defaultValue: T): T;
        getOptionalEnum<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T): Internal.Optional<T>;
        getCharOrElse(path: Internal.List_<string>, defaultValue: string): string;
        getByte(path: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(path: string, enumType: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(path: string, defaultValue: T): T;
        getByteOrElse(path: Internal.List_<string>, defaultValue: number): number;
        getLongOrElse(path: string, defaultValue: number): number;
        getOptionalInt(path: string): Internal.OptionalInt;
        getLongOrElse(path: string, defaultValueSupplier: Internal.LongSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T, defaultValueSupplier: Internal.Supplier_<T>): T;
        getOptionalEnum<T extends Internal.Enum<T>>(path: string, enumType: T, method: Internal.EnumGetMethod_): Internal.Optional<T>;
        getByte(path: string): number;
        getIntOrElse(path: string, defaultValue: number): number;
        getOptionalInt(path: Internal.List_<string>): Internal.OptionalInt;
        abstract size(): number;
        /**
         * @deprecated
        */
        abstract valueMap(): Internal.Map<string, any>;
        getEnumOrElse<T extends Internal.Enum<T>>(path: string, enumType: T, defaultValueSupplier: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(path: Internal.List_<string>, enumType: T, method: Internal.EnumGetMethod_, defaultValueSupplier: Internal.Supplier_<T>): T;
        apply<T>(path: string): T;
        get empty(): boolean
    }
    type UnmodifiableConfig_ = UnmodifiableConfig;
}
